/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitevpnpolicy.vpnpolicylist.vpnpolicy.entries.filter.lan;

import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitevpnpolicy.vpnpolicylist.vpnpolicy.entries.filter.Lan;
import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.sitevpnpolicy.vpnpolicylist.vpnpolicy.entries.filter.lan.lanprefix.LanPrefixes;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of lanPrefix.
 */
public interface LanPrefix extends Lan, Augmentable  {

    /**
     * Returns the attribute lanPrefixes.
     *
     * @return lanPrefixes value of lanPrefixes
     */
    LanPrefixes lanPrefixes();

    /**
     * Sets the attribute lanPrefixes.
     *
     * @param lanPrefixes value of lanPrefixes
     */
    void lanPrefixes(LanPrefixes lanPrefixes);

}