/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.l3vpnsvc.sites.site.sitenetworkaccesses.sitenetworkaccess.service.qos.qosprofile.qosprofile.augmentedl3vpnqosprofile;

import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.siteserviceqosprofile.qos.qosprofile.QosProfile;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.l3vpnsvc.sites.site.sitenetworkaccesses.sitenetworkaccess.service.qos.qosprofile.qosprofile.augmentedl3vpnqosprofile.customunicom.InboundClasses;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.l3vpnsvc.sites.site.sitenetworkaccesses.sitenetworkaccess.service.qos.qosprofile.qosprofile.augmentedl3vpnqosprofile.customunicom.OutboundClasses;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of customUnicom.
 */
public interface CustomUnicom extends QosProfile, Augmentable  {

    /**
     * Returns the attribute inboundClasses.
     *
     * @return inboundClasses value of inboundClasses
     */
    InboundClasses inboundClasses();

    /**
     * Returns the attribute outboundClasses.
     *
     * @return outboundClasses value of outboundClasses
     */
    OutboundClasses outboundClasses();

    /**
     * Sets the attribute inboundClasses.
     *
     * @param inboundClasses value of inboundClasses
     */
    void inboundClasses(InboundClasses inboundClasses);

    /**
     * Sets the attribute outboundClasses.
     *
     * @param outboundClasses value of outboundClasses
     */
    void outboundClasses(OutboundClasses outboundClasses);

}