/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.routedistinguisher;

import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.RdAs2;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.RdAs;
import org.onosproject.yang.gen.v1.l3vpnsvcext.rev20160730.l3vpnsvcext.RdIpv4;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of routeDistinguisherUnion.
 */
public final class RouteDistinguisherUnion {
    private RdIpv4 rdIpv4;
    private RdAs rdAs;
    private RdAs2 rdAs2;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of routeDistinguisherUnion.
     */
    private RouteDistinguisherUnion() {
    }

    /**
     * Creates an instance of rdIpv4.
     *
     * @param rdIpv4 value of rdIpv4
     */
    public RouteDistinguisherUnion(RdIpv4 rdIpv4) {
        setValue.set(0);
        this.rdIpv4 = rdIpv4;
    }

    /**
     * Creates an instance of rdAs.
     *
     * @param rdAs value of rdAs
     */
    public RouteDistinguisherUnion(RdAs rdAs) {
        setValue.set(1);
        this.rdAs = rdAs;
    }

    /**
     * Creates an instance of rdAs2.
     *
     * @param rdAs2 value of rdAs2
     */
    public RouteDistinguisherUnion(RdAs2 rdAs2) {
        setValue.set(2);
        this.rdAs2 = rdAs2;
    }

    /**
     * Returns the object of routeDistinguisherUnion for type rdIpv4.
     *
     * @param value value of routeDistinguisherUnion for type rdIpv4
     * @return routeDistinguisherUnion for type rdIpv4
     */
    public static RouteDistinguisherUnion of(RdIpv4 value) {
        return new RouteDistinguisherUnion(value);
    }

    /**
     * Returns the object of routeDistinguisherUnion for type rdAs.
     *
     * @param value value of routeDistinguisherUnion for type rdAs
     * @return routeDistinguisherUnion for type rdAs
     */
    public static RouteDistinguisherUnion of(RdAs value) {
        return new RouteDistinguisherUnion(value);
    }

    /**
     * Returns the object of routeDistinguisherUnion for type rdAs2.
     *
     * @param value value of routeDistinguisherUnion for type rdAs2
     * @return routeDistinguisherUnion for type rdAs2
     */
    public static RouteDistinguisherUnion of(RdAs2 value) {
        return new RouteDistinguisherUnion(value);
    }

    /**
     * Returns the attribute rdIpv4.
     *
     * @return rdIpv4 value of rdIpv4
     */
    public RdIpv4 rdIpv4() {
        return rdIpv4;
    }
    /**
     * Returns the attribute rdAs.
     *
     * @return rdAs value of rdAs
     */
    public RdAs rdAs() {
        return rdAs;
    }
    /**
     * Returns the attribute rdAs2.
     *
     * @return rdAs2 value of rdAs2
     */
    public RdAs2 rdAs2() {
        return rdAs2;
    }
    /**
     * Sets the attribute rdIpv4.
     *
     * @param rdIpv4 value of rdIpv4
     */
    public void rdIpv4(RdIpv4 rdIpv4) {
        this.rdIpv4 = rdIpv4;
    }
    /**
     * Sets the attribute rdAs.
     *
     * @param rdAs value of rdAs
     */
    public void rdAs(RdAs rdAs) {
        this.rdAs = rdAs;
    }
    /**
     * Sets the attribute rdAs2.
     *
     * @param rdAs2 value of rdAs2
     */
    public void rdAs2(RdAs2 rdAs2) {
        this.rdAs2 = rdAs2;
    }

    @Override
    public int hashCode() {
        return Objects.hash(rdIpv4, rdAs, rdAs2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RouteDistinguisherUnion) {
            RouteDistinguisherUnion other = (RouteDistinguisherUnion) obj;
            return
                Objects.equals(rdIpv4, other.rdIpv4) &&
                Objects.equals(rdAs, other.rdAs) &&
                Objects.equals(rdAs2, other.rdAs2);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return rdIpv4.toString();
        }
        if (setValue.get(1)) {
            return rdAs.toString();
        }
        if (setValue.get(2)) {
            return rdAs2.toString();
        }
        return null;
    }
    /**
     * Returns the object of routeDistinguisherUnion fromString input String routeDistinguisherUnion.
     *
     * @param valInString value of input String
     * @return routeDistinguisherUnion
     */
    public static RouteDistinguisherUnion fromString(String valInString) {
        try {
            RdIpv4 tmpVal = RdIpv4.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            RdAs tmpVal = RdAs.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            RdAs2 tmpVal = RdAs2.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
