/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.containerchoice.choicecase;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.containerchoice.ChoiceCase;
import org.onosproject.yang.gen.v1.modeldatatoresourcedata.rev20160826.modeldatatoresourcedata.firstlevel.containerchoice.choicecase.listcase.CaseList;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of listCase.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultListCase extends InnerModelObject implements ListCase {
    protected List<CaseList> caseList;

    @Override
    public List<CaseList> caseList() {
        return caseList;
    }

    @Override
    public void caseList(List<CaseList> caseList) {
        this.caseList = caseList;
    }

    @Override
    public void addToCaseList(CaseList addTo) {
        if (caseList == null) {
            caseList = new ArrayList<>();
        }
        caseList.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(caseList);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultListCase) {
            DefaultListCase other = (DefaultListCase) obj;
            return
                Objects.equals(caseList, other.caseList);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("caseList=" + caseList)
            .toString();
    }


    /**
     * Creates an instance of defaultListCase.
     */
    public DefaultListCase() {
    }

}