/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.modulelistandkey.rev20160826.modulelistandkey;

import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of ll1Union.
 */
public final class Ll1Union {
    private byte int8;
    private short uint8;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of ll1Union.
     */
    private Ll1Union() {
    }

    /**
     * Creates an instance of int8.
     *
     * @param int8 value of int8
     */
    public Ll1Union(byte int8) {
        setValue.set(0);
        this.int8 = int8;
    }

    /**
     * Creates an instance of uint8.
     *
     * @param uint8 value of uint8
     */
    public Ll1Union(short uint8) {
        setValue.set(1);
        this.uint8 = uint8;
    }

    /**
     * Returns the object of ll1Union for type int8.
     *
     * @param value value of ll1Union for type int8
     * @return ll1Union for type int8
     */
    public static Ll1Union of(byte value) {
        return new Ll1Union(value);
    }

    /**
     * Returns the object of ll1Union for type uint8.
     *
     * @param value value of ll1Union for type uint8
     * @return ll1Union for type uint8
     */
    public static Ll1Union of(short value) {
        return new Ll1Union(value);
    }

    /**
     * Returns the attribute int8.
     *
     * @return int8 value of int8
     */
    public byte int8() {
        return int8;
    }
    /**
     * Returns the attribute uint8.
     *
     * @return uint8 value of uint8
     */
    public short uint8() {
        return uint8;
    }
    /**
     * Sets the attribute int8.
     *
     * @param int8 value of int8
     */
    public void int8(byte int8) {
        this.int8 = int8;
    }
    /**
     * Sets the attribute uint8.
     *
     * @param uint8 value of uint8
     */
    public void uint8(short uint8) {
        this.uint8 = uint8;
    }

    @Override
    public int hashCode() {
        return Objects.hash(int8, uint8);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Ll1Union) {
            Ll1Union other = (Ll1Union) obj;
            return
                Objects.equals(int8, other.int8) &&
                Objects.equals(uint8, other.uint8);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return String.valueOf(int8);
        }
        if (setValue.get(1)) {
            return String.valueOf(uint8);
        }
        return null;
    }
    /**
     * Returns the object of ll1Union fromString input String ll1Union.
     *
     * @param valInString value of input String
     * @return ll1Union
     */
    public static Ll1Union fromString(String valInString) {
        try {
            byte tmpVal = Byte.parseByte(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            short tmpVal = Short.parseShort(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
