/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.simpledatatypes.rev20131112.simpledatatypes.cont;

import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of lfunion8Union.
 */
public final class Lfunion8Union {
    private int uint16;
    private String string;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of lfunion8Union.
     */
    private Lfunion8Union() {
    }

    /**
     * Creates an instance of uint16.
     *
     * @param uint16 value of uint16
     */
    public Lfunion8Union(int uint16) {
        setValue.set(0);
        this.uint16 = uint16;
    }

    /**
     * Creates an instance of string.
     *
     * @param string value of string
     */
    public Lfunion8Union(String string) {
        setValue.set(1);
        this.string = string;
    }

    /**
     * Returns the object of lfunion8Union for type uint16.
     *
     * @param value value of lfunion8Union for type uint16
     * @return lfunion8Union for type uint16
     */
    public static Lfunion8Union of(int value) {
        return new Lfunion8Union(value);
    }

    /**
     * Returns the object of lfunion8Union for type string.
     *
     * @param value value of lfunion8Union for type string
     * @return lfunion8Union for type string
     */
    public static Lfunion8Union of(String value) {
        return new Lfunion8Union(value);
    }

    /**
     * Returns the attribute uint16.
     *
     * @return uint16 value of uint16
     */
    public int uint16() {
        return uint16;
    }
    /**
     * Returns the attribute string.
     *
     * @return string value of string
     */
    public String string() {
        return string;
    }
    /**
     * Sets the attribute uint16.
     *
     * @param uint16 value of uint16
     */
    public void uint16(int uint16) {
        this.uint16 = uint16;
    }
    /**
     * Sets the attribute string.
     *
     * @param string value of string
     */
    public void string(String string) {
        this.string = string;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uint16, string);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Lfunion8Union) {
            Lfunion8Union other = (Lfunion8Union) obj;
            return
                Objects.equals(uint16, other.uint16) &&
                Objects.equals(string, other.string);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return String.valueOf(uint16);
        }
        if (setValue.get(1)) {
            return string;
        }
        return null;
    }
    /**
     * Returns the object of lfunion8Union fromString input String lfunion8Union.
     *
     * @param valInString value of input String
     * @return lfunion8Union
     */
    public static Lfunion8Union fromString(String valInString) {
        try {
            int tmpVal = Integer.parseInt(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            String tmpVal = (valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
