/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yangautoprefixlist.rev20160624;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yangautoprefixlist.rev20160624.yangautoprefixlist.L1;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of yangAutoPrefixList.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class YangAutoPrefixListOpParam extends InnerModelObject implements YangAutoPrefixList {
    protected List<String> leaf1;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<L1> l1;

    @Override
    public List<String> leaf1() {
        return leaf1;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<L1> l1() {
        return l1;
    }

    @Override
    public void leaf1(List<String> leaf1) {
        valueLeafFlags.set(LeafIdentifier.LEAF1.getLeafIndex());
        this.leaf1 = leaf1;
    }

    @Override
    public void l1(List<L1> l1) {
        this.l1 = l1;
    }

    @Override
    public void addToLeaf1(String addTo) {
        if (leaf1 == null) {
            leaf1 = new ArrayList<>();
        }
        leaf1.add(addTo);
    }


    @Override
    public void addToL1(L1 addTo) {
        if (l1 == null) {
            l1 = new ArrayList<>();
        }
        l1.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(leaf1, valueLeafFlags, l1);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YangAutoPrefixListOpParam) {
            YangAutoPrefixListOpParam other = (YangAutoPrefixListOpParam) obj;
            return
                Objects.equals(leaf1, other.leaf1) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(l1, other.l1);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("leaf1=" + leaf1)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("l1=" + l1)
            .toString();
    }

    /**
     * Creates an instance of yangAutoPrefixListOpParam.
     */
    public YangAutoPrefixListOpParam() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}