/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ymsiptopology.rev20140101.ymsiptopology.node.augmentedtoponode;

import java.lang.String;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of augRoutec.
 */
public class AugRoutecKeys implements KeyInfo<DefaultAugRoutec> {
    protected String val;
    /**
     * Returns the attribute val.
     *
     * @return val value of val
     */
    public String val() {
        return val;
    }

    /**
     * Sets the value to attribute val.
     *
     * @param val value of val
     */
    public void val(String val) {
        this.val = val;
    }


    @Override
    public int hashCode() {
        return Objects.hash(val);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AugRoutecKeys) {
            AugRoutecKeys other = (AugRoutecKeys) obj;
            return
                Objects.equals(val, other.val);
        }
        return false;
    }
}