/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ymstopology.rev20140101;

import java.util.List;
import org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.Choice2;
import org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.Node;

/**
 * Abstraction of an entity which represents the functionality of ymsTopology.
 */
public interface YmsTopology {

    /**
     * Returns the attribute node.
     *
     * @return node list of node
     */
    List<Node> node();

    /**
     * Returns the attribute choice2.
     *
     * @return choice2 value of choice2
     */
    Choice2 choice2();

    /**
     * Sets the attribute node.
     *
     * @param node list of node
     */
    void node(List<Node> node);

    /**
     * Sets the attribute choice2.
     *
     * @param choice2 value of choice2
     */
    void choice2(Choice2 choice2);

    /**
     * Adds to the list of node.
     *
     * @param addTo value of node
     */
    void addToNode(Node addTo);

}