/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.choice2.case2b.choice3b;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.choice2.case2b.Choice3b;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of case3Bii.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCase3Bii extends InnerModelObject implements Case3Bii {
    protected String leaf3Biia;
    protected String leaf3Biib;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public String leaf3Biia() {
        return leaf3Biia;
    }

    @Override
    public String leaf3Biib() {
        return leaf3Biib;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void leaf3Biia(String leaf3Biia) {
        valueLeafFlags.set(LeafIdentifier.LEAF3BIIA.getLeafIndex());
        this.leaf3Biia = leaf3Biia;
    }

    @Override
    public void leaf3Biib(String leaf3Biib) {
        valueLeafFlags.set(LeafIdentifier.LEAF3BIIB.getLeafIndex());
        this.leaf3Biib = leaf3Biib;
    }

    @Override
    public int hashCode() {
        return Objects.hash(leaf3Biia, leaf3Biib, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCase3Bii) {
            DefaultCase3Bii other = (DefaultCase3Bii) obj;
            return
                Objects.equals(leaf3Biia, other.leaf3Biia) &&
                Objects.equals(leaf3Biib, other.leaf3Biib) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("leaf3Biia=" + leaf3Biia)
            .add("leaf3Biib=" + leaf3Biib)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultCase3Bii.
     */
    public DefaultCase3Bii() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}