/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.node;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.ymstopology.rev20140101.ymstopology.node.terminationpoints.TerminationPoint;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of terminationPoints.
 */
public interface TerminationPoints extends Augmentable  {

    /**
     * Identify the leaf of TerminationPoints.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents numberOfTp.
         */
        NUMBEROFTP(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute numberOfTp.
     *
     * @return numberOfTp value of numberOfTp
     */
    short numberOfTp();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute terminationPoint.
     *
     * @return terminationPoint list of terminationPoint
     */
    List<TerminationPoint> terminationPoint();

    /**
     * Sets the attribute numberOfTp.
     *
     * @param numberOfTp value of numberOfTp
     */
    void numberOfTp(short numberOfTp);

    /**
     * Sets the attribute terminationPoint.
     *
     * @param terminationPoint list of terminationPoint
     */
    void terminationPoint(List<TerminationPoint> terminationPoint);

    /**
     * Adds to the list of terminationPoint.
     *
     * @param addTo value of terminationPoint
     */
    void addToTerminationPoint(TerminationPoint addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}