/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetopology.rev20160317.yrtietftetopology.telinkinfoattributes;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes.Srlg;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of teSrlgs.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTeSrlgs extends InnerModelObject implements TeSrlgs {
    protected List<Srlg> values;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public List<Srlg> values() {
        return values;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void values(List<Srlg> values) {
        valueLeafFlags.set(LeafIdentifier.VALUES.getLeafIndex());
        this.values = values;
    }

    @Override
    public void addToValues(Srlg addTo) {
        if (values == null) {
            values = new ArrayList<>();
        }
        values.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(values, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTeSrlgs) {
            DefaultTeSrlgs other = (DefaultTeSrlgs) obj;
            return
                Objects.equals(values, other.values) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("values=" + values)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultTeSrlgs.
     */
    public DefaultTeSrlgs() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}