/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtietftetypes.rev20160320.yrtietftetypes;

/**
 * Represents the implementation of lspEncodingTypes.
 */
public abstract class LspEncodingTypes {

    /**
     * Returns the attribute lsp-encoding-types.
     *
     * @return lsp-encoding-types value of lsp-encoding-types
     */
    public static String lspEncodingTypesToString() {
        return "lsp-encoding-types";
    }

    /**
     * Returns the object of lspEncodingTypes fromString input String lspEncodingTypes.
     *
     * @param valInString value of input String
     * @return lspEncodingTypes
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("lsp-encoding-types")) {
            return LspEncodingTypes.class;
        } else if (valInString.equals("lsp-encoding-packet")) {
            return LspEncodingPacket.class;
        } else if (valInString.equals("lsp-encoding-ethernet")) {
            return LspEncodingEthernet.class;
        } else if (valInString.equals("lsp-encoding-pdh")) {
            return LspEncodingPdh.class;
        } else if (valInString.equals("lsp-encoding-sdh")) {
            return LspEncodingSdh.class;
        } else if (valInString.equals("lsp-encoding-digital-wrapper")) {
            return LspEncodingDigitalWrapper.class;
        } else if (valInString.equals("lsp-encoding-lambda")) {
            return LspEncodingLambda.class;
        } else if (valInString.equals("lsp-encoding-fiber")) {
            return LspEncodingFiber.class;
        } else if (valInString.equals("lsp-encoding-fiber-channel")) {
            return LspEncodingFiberChannel.class;
        } else if (valInString.equals("lsp-encoding-oduk")) {
            return LspEncodingOduk.class;
        } else if (valInString.equals("lsp-encoding-optical-channel")) {
            return LspEncodingOpticalChannel.class;
        } else if (valInString.equals("lsp-encoding-line")) {
            return LspEncodingLine.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}