/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription;

/**
 * Represents the implementation of stream.
 */
public abstract class Stream {

    /**
     * Returns the attribute stream.
     *
     * @return stream value of stream
     */
    public static String streamToString() {
        return "stream";
    }

    /**
     * Returns the object of stream fromString input String stream.
     *
     * @param valInString value of input String
     * @return stream
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("stream")) {
            return Stream.class;
        } else if (valInString.equals("NETCONF")) {
            return Netconf.class;
        } else if (valInString.equals("SYSLOG")) {
            return Syslog.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}