/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.establishsubscription.establishsubscriptionoutput.result.augmentedresult;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.SubscriptionId;
import org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.subscriptionresponsewithhints.Result;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of success.
 */
public class DefaultSuccess extends InnerModelObject implements Success {
    protected SubscriptionId identifier;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public SubscriptionId identifier() {
        return identifier;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void identifier(SubscriptionId identifier) {
        valueLeafFlags.set(LeafIdentifier.IDENTIFIER.getLeafIndex());
        this.identifier = identifier;
    }

    @Override
    public int hashCode() {
        return Objects.hash(identifier, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultSuccess) {
            DefaultSuccess other = (DefaultSuccess) obj;
            return
                Objects.equals(identifier, other.identifier) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("identifier=" + identifier)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultSuccess.
     */
    public DefaultSuccess() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}