/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.notificationorigininfo.notificationorigin;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrtietfinettypes.rev20130715.yrtietfinettypes.IpAddressNoZone;
import org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.notificationorigininfo.NotificationOrigin;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of addressOriginated.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAddressOriginated extends InnerModelObject implements AddressOriginated {
    protected String sourceVrf;
    protected IpAddressNoZone sourceAddress;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public String sourceVrf() {
        return sourceVrf;
    }

    @Override
    public IpAddressNoZone sourceAddress() {
        return sourceAddress;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void sourceVrf(String sourceVrf) {
        valueLeafFlags.set(LeafIdentifier.SOURCEVRF.getLeafIndex());
        this.sourceVrf = sourceVrf;
    }

    @Override
    public void sourceAddress(IpAddressNoZone sourceAddress) {
        valueLeafFlags.set(LeafIdentifier.SOURCEADDRESS.getLeafIndex());
        this.sourceAddress = sourceAddress;
    }

    @Override
    public int hashCode() {
        return Objects.hash(sourceVrf, sourceAddress, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAddressOriginated) {
            DefaultAddressOriginated other = (DefaultAddressOriginated) obj;
            return
                Objects.equals(sourceVrf, other.sourceVrf) &&
                Objects.equals(sourceAddress, other.sourceAddress) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("sourceVrf=" + sourceVrf)
            .add("sourceAddress=" + sourceAddress)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultAddressOriginated.
     */
    public DefaultAddressOriginated() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}