/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.subscriptions.subscription.receivers.receiver;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrtietfyangtypes.rev20130715.yrtietfyangtypes.Counter64;
import org.onosproject.yang.gen.v1.yrtsubscription.yrtsubscription.SubscriptionStatusType;

/**
 * Abstraction of an entity which represents the functionality of augmentedReceiver.
 */
public interface AugmentedReceiver {

    /**
     * Identify the leaf of AugmentedReceiver.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents pushedNotifications.
         */
        PUSHEDNOTIFICATIONS(1),
        /**
         * Represents excludedNotifications.
         */
        EXCLUDEDNOTIFICATIONS(2),
        /**
         * Represents status.
         */
        STATUS(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute pushedNotifications.
     *
     * @return pushedNotifications value of pushedNotifications
     */
    Counter64 pushedNotifications();

    /**
     * Returns the attribute excludedNotifications.
     *
     * @return excludedNotifications value of excludedNotifications
     */
    Counter64 excludedNotifications();

    /**
     * Returns the attribute status.
     *
     * @return status value of status
     */
    SubscriptionStatusType status();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute pushedNotifications.
     *
     * @param pushedNotifications value of pushedNotifications
     */
    void pushedNotifications(Counter64 pushedNotifications);

    /**
     * Sets the attribute excludedNotifications.
     *
     * @param excludedNotifications value of excludedNotifications
     */
    void excludedNotifications(Counter64 excludedNotifications);

    /**
     * Sets the attribute status.
     *
     * @param status value of status
     */
    void status(SubscriptionStatusType status);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}