/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbaugmentfromanotherfile.rev20160826.ytbaugmentfromanotherfile.networks.network.node;

import java.util.List;
import org.onosproject.yang.gen.v1.ytbaugmentfromanotherfile.rev20160826.ytbaugmentfromanotherfile.networks.network.node.augmentedndnode.TerminationPoint;

/**
 * Abstraction of an entity which represents the functionality of augmentedNdNode.
 */
public interface AugmentedNdNode {

    /**
     * Returns the attribute terminationPoint.
     *
     * @return terminationPoint list of terminationPoint
     */
    List<TerminationPoint> terminationPoint();

    /**
     * Sets the attribute terminationPoint.
     *
     * @param terminationPoint list of terminationPoint
     */
    void terminationPoint(List<TerminationPoint> terminationPoint);

    /**
     * Adds to the list of terminationPoint.
     *
     * @param addTo value of terminationPoint
     */
    void addToTerminationPoint(TerminationPoint addTo);

}