/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbdatatype.rev20160826.ytbdatatype;

import java.math.BigInteger;
import org.onosproject.yang.gen.v1.ytbdatatype.rev20160826.ytbdatatype.enumleaflistunion.EnumLeafListUnionEnum1;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of enumLeafListUnion.
 */
public final class EnumLeafListUnion {
    private BigInteger uint64;
    private EnumLeafListUnionEnum1 enumeration;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of enumLeafListUnion.
     */
    private EnumLeafListUnion() {
    }

    /**
     * Creates an instance of uint64.
     *
     * @param uint64 value of uint64
     */
    public EnumLeafListUnion(BigInteger uint64) {
        setValue.set(0);
        this.uint64 = uint64;
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public EnumLeafListUnion(EnumLeafListUnionEnum1 enumeration) {
        setValue.set(1);
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of enumLeafListUnion for type uint64.
     *
     * @param value value of enumLeafListUnion for type uint64
     * @return enumLeafListUnion for type uint64
     */
    public static EnumLeafListUnion of(BigInteger value) {
        return new EnumLeafListUnion(value);
    }

    /**
     * Returns the object of enumLeafListUnion for type enumeration.
     *
     * @param value value of enumLeafListUnion for type enumeration
     * @return enumLeafListUnion for type enumeration
     */
    public static EnumLeafListUnion of(EnumLeafListUnionEnum1 value) {
        return new EnumLeafListUnion(value);
    }

    /**
     * Returns the attribute uint64.
     *
     * @return uint64 value of uint64
     */
    public BigInteger uint64() {
        return uint64;
    }
    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public EnumLeafListUnionEnum1 enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute uint64.
     *
     * @param uint64 value of uint64
     */
    public void uint64(BigInteger uint64) {
        this.uint64 = uint64;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(EnumLeafListUnionEnum1 enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(uint64, enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EnumLeafListUnion) {
            EnumLeafListUnion other = (EnumLeafListUnion) obj;
            return
                Objects.equals(uint64, other.uint64) &&
                Objects.equals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return uint64.toString();
        }
        if (setValue.get(1)) {
            return enumeration.toString();
        }
        return null;
    }
    /**
     * Returns the object of enumLeafListUnion fromString input String enumLeafListUnion.
     *
     * @param valInString value of input String
     * @return enumLeafListUnion
     */
    public static EnumLeafListUnion fromString(String valInString) {
        try {
            BigInteger tmpVal = new BigInteger(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            EnumLeafListUnionEnum1 tmpVal = EnumLeafListUnionEnum1.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
