/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes.cont1.Cont2;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of cont1.
 */
public interface Cont1 extends Augmentable  {

    /**
     * Identify the leaf of Cont1.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents leaf1.
         */
        LEAF1(1),
        /**
         * Represents leaf2.
         */
        LEAF2(2),
        /**
         * Represents leaf3.
         */
        LEAF3(3),
        /**
         * Represents leaf4.
         */
        LEAF4(4),
        /**
         * Represents leaf5.
         */
        LEAF5(5),
        /**
         * Represents leaf6.
         */
        LEAF6(6),
        /**
         * Represents leaf7.
         */
        LEAF7(7),
        /**
         * Represents leaf8.
         */
        LEAF8(8),
        /**
         * Represents leaf9.
         */
        LEAF9(9),
        /**
         * Represents leaf10.
         */
        LEAF10(10),
        /**
         * Represents leaf11.
         */
        LEAF11(11),
        /**
         * Represents leaf12.
         */
        LEAF12(12),
        /**
         * Represents leaf13.
         */
        LEAF13(13),
        /**
         * Represents leaf14.
         */
        LEAF14(14),
        /**
         * Represents leaf15.
         */
        LEAF15(15),
        /**
         * Represents ll1.
         */
        LL1(16),
        /**
         * Represents ll2.
         */
        LL2(17),
        /**
         * Represents ll3.
         */
        LL3(18),
        /**
         * Represents ll4.
         */
        LL4(19),
        /**
         * Represents ll5.
         */
        LL5(20),
        /**
         * Represents ll6.
         */
        LL6(21),
        /**
         * Represents ll7.
         */
        LL7(22),
        /**
         * Represents ll8.
         */
        LL8(23),
        /**
         * Represents ll9.
         */
        LL9(24),
        /**
         * Represents ll10.
         */
        LL10(25),
        /**
         * Represents ll11.
         */
        LL11(26),
        /**
         * Represents ll12.
         */
        LL12(27),
        /**
         * Represents ll13.
         */
        LL13(28),
        /**
         * Represents ll14.
         */
        LL14(29),
        /**
         * Represents ll15.
         */
        LL15(30);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute leaf1.
     *
     * @return leaf1 value of leaf1
     */
    String leaf1();

    /**
     * Returns the attribute leaf2.
     *
     * @return leaf2 value of leaf2
     */
    Def1 leaf2();

    /**
     * Returns the attribute leaf3.
     *
     * @return leaf3 value of leaf3
     */
    byte[] leaf3();

    /**
     * Returns the attribute leaf4.
     *
     * @return leaf4 value of leaf4
     */
    Def1 leaf4();

    /**
     * Returns the attribute leaf5.
     *
     * @return leaf5 value of leaf5
     */
    Class<? extends Type> leaf5();

    /**
     * Returns the attribute leaf6.
     *
     * @return leaf6 value of leaf6
     */
    String leaf6();

    /**
     * Returns the attribute leaf7.
     *
     * @return leaf7 value of leaf7
     */
    BitSet leaf7();

    /**
     * Returns the attribute leaf8.
     *
     * @return leaf8 value of leaf8
     */
    boolean leaf8();

    /**
     * Returns the attribute leaf9.
     *
     * @return leaf9 value of leaf9
     */
    Def2 leaf9();

    /**
     * Returns the attribute leaf10.
     *
     * @return leaf10 value of leaf10
     */
    Def3 leaf10();

    /**
     * Returns the attribute leaf11.
     *
     * @return leaf11 value of leaf11
     */
    boolean leaf11();

    /**
     * Returns the attribute leaf12.
     *
     * @return leaf12 value of leaf12
     */
    byte[] leaf12();

    /**
     * Returns the attribute leaf13.
     *
     * @return leaf13 value of leaf13
     */
    Def1 leaf13();

    /**
     * Returns the attribute leaf14.
     *
     * @return leaf14 value of leaf14
     */
    Def6 leaf14();

    /**
     * Returns the attribute leaf15.
     *
     * @return leaf15 value of leaf15
     */
    Def7 leaf15();

    /**
     * Returns the attribute ll1.
     *
     * @return ll1 list of ll1
     */
    List<String> ll1();

    /**
     * Returns the attribute ll2.
     *
     * @return ll2 list of ll2
     */
    List<Def1> ll2();

    /**
     * Returns the attribute ll3.
     *
     * @return ll3 list of ll3
     */
    List<byte[]> ll3();

    /**
     * Returns the attribute ll4.
     *
     * @return ll4 list of ll4
     */
    List<Def1> ll4();

    /**
     * Returns the attribute ll5.
     *
     * @return ll5 list of ll5
     */
    List<Class<? extends Type>> ll5();

    /**
     * Returns the attribute ll6.
     *
     * @return ll6 list of ll6
     */
    List<String> ll6();

    /**
     * Returns the attribute ll7.
     *
     * @return ll7 list of ll7
     */
    List<BitSet> ll7();

    /**
     * Returns the attribute ll8.
     *
     * @return ll8 list of ll8
     */
    List<Boolean> ll8();

    /**
     * Returns the attribute ll9.
     *
     * @return ll9 list of ll9
     */
    List<Def2> ll9();

    /**
     * Returns the attribute ll10.
     *
     * @return ll10 list of ll10
     */
    List<Def3> ll10();

    /**
     * Returns the attribute ll11.
     *
     * @return ll11 list of ll11
     */
    List<Boolean> ll11();

    /**
     * Returns the attribute ll12.
     *
     * @return ll12 list of ll12
     */
    List<byte[]> ll12();

    /**
     * Returns the attribute ll13.
     *
     * @return ll13 list of ll13
     */
    List<Def1> ll13();

    /**
     * Returns the attribute ll14.
     *
     * @return ll14 list of ll14
     */
    List<Def6> ll14();

    /**
     * Returns the attribute ll15.
     *
     * @return ll15 list of ll15
     */
    List<Def7> ll15();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute cont2.
     *
     * @return cont2 value of cont2
     */
    Cont2 cont2();

    /**
     * Sets the attribute leaf1.
     *
     * @param leaf1 value of leaf1
     */
    void leaf1(String leaf1);

    /**
     * Sets the attribute leaf2.
     *
     * @param leaf2 value of leaf2
     */
    void leaf2(Def1 leaf2);

    /**
     * Sets the attribute leaf3.
     *
     * @param leaf3 value of leaf3
     */
    void leaf3(byte[] leaf3);

    /**
     * Sets the attribute leaf4.
     *
     * @param leaf4 value of leaf4
     */
    void leaf4(Def1 leaf4);

    /**
     * Sets the attribute leaf5.
     *
     * @param leaf5 value of leaf5
     */
    void leaf5(Class<? extends Type> leaf5);

    /**
     * Sets the attribute leaf6.
     *
     * @param leaf6 value of leaf6
     */
    void leaf6(String leaf6);

    /**
     * Sets the attribute leaf7.
     *
     * @param leaf7 value of leaf7
     */
    void leaf7(BitSet leaf7);

    /**
     * Sets the attribute leaf8.
     *
     * @param leaf8 value of leaf8
     */
    void leaf8(boolean leaf8);

    /**
     * Sets the attribute leaf9.
     *
     * @param leaf9 value of leaf9
     */
    void leaf9(Def2 leaf9);

    /**
     * Sets the attribute leaf10.
     *
     * @param leaf10 value of leaf10
     */
    void leaf10(Def3 leaf10);

    /**
     * Sets the attribute leaf11.
     *
     * @param leaf11 value of leaf11
     */
    void leaf11(boolean leaf11);

    /**
     * Sets the attribute leaf12.
     *
     * @param leaf12 value of leaf12
     */
    void leaf12(byte[] leaf12);

    /**
     * Sets the attribute leaf13.
     *
     * @param leaf13 value of leaf13
     */
    void leaf13(Def1 leaf13);

    /**
     * Sets the attribute leaf14.
     *
     * @param leaf14 value of leaf14
     */
    void leaf14(Def6 leaf14);

    /**
     * Sets the attribute leaf15.
     *
     * @param leaf15 value of leaf15
     */
    void leaf15(Def7 leaf15);

    /**
     * Sets the attribute ll1.
     *
     * @param ll1 list of ll1
     */
    void ll1(List<String> ll1);

    /**
     * Sets the attribute ll2.
     *
     * @param ll2 list of ll2
     */
    void ll2(List<Def1> ll2);

    /**
     * Sets the attribute ll3.
     *
     * @param ll3 list of ll3
     */
    void ll3(List<byte[]> ll3);

    /**
     * Sets the attribute ll4.
     *
     * @param ll4 list of ll4
     */
    void ll4(List<Def1> ll4);

    /**
     * Sets the attribute ll5.
     *
     * @param ll5 list of ll5
     */
    void ll5(List<Class<? extends Type>> ll5);

    /**
     * Sets the attribute ll6.
     *
     * @param ll6 list of ll6
     */
    void ll6(List<String> ll6);

    /**
     * Sets the attribute ll7.
     *
     * @param ll7 list of ll7
     */
    void ll7(List<BitSet> ll7);

    /**
     * Sets the attribute ll8.
     *
     * @param ll8 list of ll8
     */
    void ll8(List<Boolean> ll8);

    /**
     * Sets the attribute ll9.
     *
     * @param ll9 list of ll9
     */
    void ll9(List<Def2> ll9);

    /**
     * Sets the attribute ll10.
     *
     * @param ll10 list of ll10
     */
    void ll10(List<Def3> ll10);

    /**
     * Sets the attribute ll11.
     *
     * @param ll11 list of ll11
     */
    void ll11(List<Boolean> ll11);

    /**
     * Sets the attribute ll12.
     *
     * @param ll12 list of ll12
     */
    void ll12(List<byte[]> ll12);

    /**
     * Sets the attribute ll13.
     *
     * @param ll13 list of ll13
     */
    void ll13(List<Def1> ll13);

    /**
     * Sets the attribute ll14.
     *
     * @param ll14 list of ll14
     */
    void ll14(List<Def6> ll14);

    /**
     * Sets the attribute ll15.
     *
     * @param ll15 list of ll15
     */
    void ll15(List<Def7> ll15);

    /**
     * Sets the attribute cont2.
     *
     * @param cont2 value of cont2
     */
    void cont2(Cont2 cont2);

    /**
     * Adds to the list of ll1.
     *
     * @param addTo value of ll1
     */
    void addToLl1(String addTo);

    /**
     * Adds to the list of ll2.
     *
     * @param addTo value of ll2
     */
    void addToLl2(Def1 addTo);

    /**
     * Adds to the list of ll3.
     *
     * @param addTo value of ll3
     */
    void addToLl3(byte[] addTo);

    /**
     * Adds to the list of ll4.
     *
     * @param addTo value of ll4
     */
    void addToLl4(Def1 addTo);

    /**
     * Adds to the list of ll5.
     *
     * @param addTo value of ll5
     */
    void addToLl5(Class<? extends Type> addTo);

    /**
     * Adds to the list of ll6.
     *
     * @param addTo value of ll6
     */
    void addToLl6(String addTo);

    /**
     * Adds to the list of ll7.
     *
     * @param addTo value of ll7
     */
    void addToLl7(BitSet addTo);

    /**
     * Adds to the list of ll8.
     *
     * @param addTo value of ll8
     */
    void addToLl8(Boolean addTo);

    /**
     * Adds to the list of ll9.
     *
     * @param addTo value of ll9
     */
    void addToLl9(Def2 addTo);

    /**
     * Adds to the list of ll10.
     *
     * @param addTo value of ll10
     */
    void addToLl10(Def3 addTo);

    /**
     * Adds to the list of ll11.
     *
     * @param addTo value of ll11
     */
    void addToLl11(Boolean addTo);

    /**
     * Adds to the list of ll12.
     *
     * @param addTo value of ll12
     */
    void addToLl12(byte[] addTo);

    /**
     * Adds to the list of ll13.
     *
     * @param addTo value of ll13
     */
    void addToLl13(Def1 addTo);

    /**
     * Adds to the list of ll14.
     *
     * @param addTo value of ll14
     */
    void addToLl14(Def6 addTo);

    /**
     * Adds to the list of ll15.
     *
     * @param addTo value of ll15
     */
    void addToLl15(Def7 addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}