/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes;

import org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes.def7.Def7Union;
import java.util.Objects;

/**
 * Represents the implementation of def7.
 */
public final class Def7 {

    private Def7Union union;

    /**
     * Creates an instance of def7.
     */
    private Def7() {
    }

    /**
     * Creates an instance of union.
     *
     * @param union value of union
     */
    public Def7(Def7Union union) {
        this.union = union;
    }

    /**
     * Returns the object of def7 for type union.
     *
     * @param value value of def7 for type union
     * @return def7 for type union
     */
    public static Def7 of(Def7Union value) {
        return new Def7(value);
    }

    /**
     * Returns the attribute union.
     *
     * @return union value of union
     */
    public Def7Union union() {
        return union;
    }
    /**
     * Sets the attribute union.
     *
     * @param union value of union
     */
    public void union(Def7Union union) {
        this.union = union;
    }

    @Override
    public int hashCode() {
        return Objects.hash(union);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Def7) {
            Def7 other = (Def7) obj;
            return
                Objects.equals(union, other.union);
        }
        return false;
    }

    @Override
    public String toString() {
        return union.toString();
    }
    /**
     * Returns the object of def7 fromString input String def7.
     *
     * @param valInString value of input String
     * @return def7
     */
    public static Def7 fromString(String valInString) {
        try {
            Def7Union tmpVal = Def7Union.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
