/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes.def1.def1union;

/**
 * Represents ENUM data of def1UnionEnum1.
 */
public enum Def1UnionEnum1 {

    /**
     * Represents ten.
     */
    TEN(10, "ten"),

    /**
     * Represents hundred.
     */
    HUNDRED(100, "hundred"),

    /**
     * Represents thousand.
     */
    THOUSAND(1000, "thousand"),

    /**
     * Represents *.
     */
    ASTERISK(10000, "*");

    private int def1UnionEnum1;
    private String schemaName;

    /**
     * Creates an instance of def1UnionEnum1.
     *
     * @param def1UnionEnum1 value of def1UnionEnum1
     */
     Def1UnionEnum1(int def1UnionEnum1, String schemaName) {
        this.def1UnionEnum1 = def1UnionEnum1;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of def1UnionEnum1 for.
     *
     * @param value value of def1UnionEnum1 for
     * @return def1UnionEnum1 for
     */
    public static Def1UnionEnum1 of(int value) {
        switch (value) {
            case 10:
                return Def1UnionEnum1.TEN;
            case 100:
                return Def1UnionEnum1.HUNDRED;
            case 1000:
                return Def1UnionEnum1.THOUSAND;
            case 10000:
                return Def1UnionEnum1.ASTERISK;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of def1UnionEnum1 for.
     *
     * @param value value of def1UnionEnum1 for
     * @return def1UnionEnum1 for
     */
    public static Def1UnionEnum1 of(String value) {
        switch (value) {
            case "ten":
                return Def1UnionEnum1.TEN;
            case "hundred":
                return Def1UnionEnum1.HUNDRED;
            case "thousand":
                return Def1UnionEnum1.THOUSAND;
            case "*":
                return Def1UnionEnum1.ASTERISK;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute def1UnionEnum1.
     *
     * @return def1UnionEnum1 value of def1UnionEnum1
     */
    public int def1UnionEnum1() {
        return def1UnionEnum1;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
