/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes.def7;

import org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes.Physical;
import org.onosproject.yang.gen.v1.ytbdatatypes.rev20160826.ytbdatatypes.Virtual;
import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of def7Union.
 */
public final class Def7Union {
    private Class<? extends Physical> identityref;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of def7Union.
     */
    private Def7Union() {
    }

    /**
     * Creates an instance of identityref.
     *
     * @param identityref value of identityref
     */
    public Def7Union(Class<? extends Physical> identityref) {
        setValue.set(0);
        this.identityref = identityref;
    }

    /**
     * Returns the object of def7Union for type identityref.
     *
     * @param value value of def7Union for type identityref
     * @return def7Union for type identityref
     */
    public static Def7Union of(Class<? extends Physical> value) {
        return new Def7Union(value);
    }

    /**
     * Returns the attribute identityref.
     *
     * @return identityref value of identityref
     */
    public Class<? extends Physical> identityref() {
        return identityref;
    }
    /**
     * Sets the attribute identityref.
     *
     * @param identityref value of identityref
     */
    public void identityref(Class<? extends Physical> identityref) {
        this.identityref = identityref;
    }

    @Override
    public int hashCode() {
        return Objects.hash(identityref);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Def7Union) {
            Def7Union other = (Def7Union) obj;
            return
                Objects.equals(identityref, other.identityref);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            if (identityref.equals(Physical.class)) {
                return Physical.physicalToString();
            }
        }
        if (setValue.get(1)) {
            if (identityref.equals(Virtual.class)) {
                return Virtual.virtualToString();
            }
        }
        return null;
    }
    /**
     * Returns the object of def7Union fromString input String def7Union.
     *
     * @param valInString value of input String
     * @return def7Union
     */
    public static Def7Union fromString(String valInString) {
        try {
            Class<? extends Physical> tmpVal = Physical.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
