/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbderivedtypewithbitsandbinary.rev20160826;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ytbderivedtypewithbitsandbinary.rev20160826.ytbderivedtypewithbitsandbinary.Derivedbinarya;
import org.onosproject.yang.gen.v1.ytbderivedtypewithbitsandbinary.rev20160826.ytbderivedtypewithbitsandbinary.Derivedbitsa;
import org.onosproject.yang.gen.v1.ytbderivedtypewithbitsandbinary.rev20160826.ytbderivedtypewithbitsandbinary.ForunionUnion;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ytbDerivedTypeWithBitsAndBinary.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class YtbDerivedTypeWithBitsAndBinaryOpParam extends InnerModelObject implements YtbDerivedTypeWithBitsAndBinary {
    protected Derivedbinarya forbinary;
    protected Derivedbitsa forbits;
    protected ForunionUnion forunion;
    protected List<Derivedbinarya> forbinarylist;
    protected List<Derivedbitsa> forbitslist;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public Derivedbinarya forbinary() {
        return forbinary;
    }

    @Override
    public Derivedbitsa forbits() {
        return forbits;
    }

    @Override
    public ForunionUnion forunion() {
        return forunion;
    }

    @Override
    public List<Derivedbinarya> forbinarylist() {
        return forbinarylist;
    }

    @Override
    public List<Derivedbitsa> forbitslist() {
        return forbitslist;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void forbinary(Derivedbinarya forbinary) {
        valueLeafFlags.set(LeafIdentifier.FORBINARY.getLeafIndex());
        this.forbinary = forbinary;
    }

    @Override
    public void forbits(Derivedbitsa forbits) {
        valueLeafFlags.set(LeafIdentifier.FORBITS.getLeafIndex());
        this.forbits = forbits;
    }

    @Override
    public void forunion(ForunionUnion forunion) {
        valueLeafFlags.set(LeafIdentifier.FORUNION.getLeafIndex());
        this.forunion = forunion;
    }

    @Override
    public void forbinarylist(List<Derivedbinarya> forbinarylist) {
        valueLeafFlags.set(LeafIdentifier.FORBINARYLIST.getLeafIndex());
        this.forbinarylist = forbinarylist;
    }

    @Override
    public void forbitslist(List<Derivedbitsa> forbitslist) {
        valueLeafFlags.set(LeafIdentifier.FORBITSLIST.getLeafIndex());
        this.forbitslist = forbitslist;
    }

    @Override
    public void addToForbinarylist(Derivedbinarya addTo) {
        if (forbinarylist == null) {
            forbinarylist = new ArrayList<>();
        }
        forbinarylist.add(addTo);
    }


    @Override
    public void addToForbitslist(Derivedbitsa addTo) {
        if (forbitslist == null) {
            forbitslist = new ArrayList<>();
        }
        forbitslist.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(forbinary, forbits, forunion, forbinarylist, forbitslist, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YtbDerivedTypeWithBitsAndBinaryOpParam) {
            YtbDerivedTypeWithBitsAndBinaryOpParam other = (YtbDerivedTypeWithBitsAndBinaryOpParam) obj;
            return
                Objects.equals(forbinary, other.forbinary) &&
                Objects.equals(forbits, other.forbits) &&
                Objects.equals(forunion, other.forunion) &&
                Objects.equals(forbinarylist, other.forbinarylist) &&
                Objects.equals(forbitslist, other.forbitslist) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("forbinary=" + forbinary)
            .add("forbits=" + forbits)
            .add("forunion=" + forunion)
            .add("forbinarylist=" + forbinarylist)
            .add("forbitslist=" + forbitslist)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }

    /**
     * Creates an instance of ytbDerivedTypeWithBitsAndBinaryOpParam.
     */
    public YtbDerivedTypeWithBitsAndBinaryOpParam() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}