/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbmultimoduleb.rev20160826;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ytbmultimoduleb.rev20160826.ytbmultimoduleb.Ytbmultilistb;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ytbMultiModuleb.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class YtbMultiModulebOpParam extends InnerModelObject implements YtbMultiModuleb {
    protected List<Ytbmultilistb> ytbmultilistb;

    @Override
    public List<Ytbmultilistb> ytbmultilistb() {
        return ytbmultilistb;
    }

    @Override
    public void ytbmultilistb(List<Ytbmultilistb> ytbmultilistb) {
        this.ytbmultilistb = ytbmultilistb;
    }

    @Override
    public void addToYtbmultilistb(Ytbmultilistb addTo) {
        if (ytbmultilistb == null) {
            ytbmultilistb = new ArrayList<>();
        }
        ytbmultilistb.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(ytbmultilistb);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YtbMultiModulebOpParam) {
            YtbMultiModulebOpParam other = (YtbMultiModulebOpParam) obj;
            return
                Objects.equals(ytbmultilistb, other.ytbmultilistb);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("ytbmultilistb=" + ytbmultilistb)
            .toString();
    }

    /**
     * Creates an instance of ytbMultiModulebOpParam.
     */
    public YtbMultiModulebOpParam() {
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}