/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ytbsimpleaugment.rev20160826.ytbsimpleaugment.cont1.cont2;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.ytbsimpleaugment.rev20160826.ytbsimpleaugment.cont1.cont2.augmentedcont2.Cont1s;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of augmentedCont2.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAugmentedCont2 extends InnerModelObject implements AugmentedCont2 {
    protected int leaf4;
    protected BitSet valueLeafFlags = new BitSet();
    protected Cont1s cont1s;

    @Override
    public int leaf4() {
        return leaf4;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Cont1s cont1s() {
        return cont1s;
    }

    @Override
    public void leaf4(int leaf4) {
        valueLeafFlags.set(LeafIdentifier.LEAF4.getLeafIndex());
        this.leaf4 = leaf4;
    }

    @Override
    public void cont1s(Cont1s cont1s) {
        this.cont1s = cont1s;
    }

    @Override
    public int hashCode() {
        return Objects.hash(leaf4, valueLeafFlags, cont1s);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAugmentedCont2) {
            DefaultAugmentedCont2 other = (DefaultAugmentedCont2) obj;
            return
                Objects.equals(leaf4, other.leaf4) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(cont1s, other.cont1s);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("leaf4=" + leaf4)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("cont1s=" + cont1s)
            .toString();
    }


    /**
     * Creates an instance of defaultAugmentedCont2.
     */
    public DefaultAugmentedCont2() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}