/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.datamodel;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.onosproject.yang.compiler.datamodel.CollisionDetector;
import org.onosproject.yang.compiler.datamodel.InvalidOpTypeHolder;
import org.onosproject.yang.compiler.datamodel.RpcNotificationContainer;
import org.onosproject.yang.compiler.datamodel.SchemaDataNode;
import org.onosproject.yang.compiler.datamodel.TraversalType;
import org.onosproject.yang.compiler.datamodel.YangAugment;
import org.onosproject.yang.compiler.datamodel.YangAugmentableNode;
import org.onosproject.yang.compiler.datamodel.YangCase;
import org.onosproject.yang.compiler.datamodel.YangLeaf;
import org.onosproject.yang.compiler.datamodel.YangLeafList;
import org.onosproject.yang.compiler.datamodel.YangLeavesHolder;
import org.onosproject.yang.compiler.datamodel.YangNamespace;
import org.onosproject.yang.compiler.datamodel.YangNodeType;
import org.onosproject.yang.compiler.datamodel.YangRevision;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.YangUses;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.SchemaContext;
import org.onosproject.yang.model.SchemaId;

public abstract class YangNode
implements Cloneable,
Serializable,
YangSchemaNode,
Comparable<YangNode> {
    private static final long serialVersionUID = 806201601L;
    private YangSchemaNodeIdentifier yangSchemaNodeIdentifier;
    private SchemaId schemaId;
    private YangNodeType nodeType;
    private DataNode.Type dataNodeType;
    private YangNode parent;
    private SchemaContext parentContext;
    private YangNode child;
    private YangNode nextSibling;
    private YangNode previousSibling;
    private int priority;
    private boolean isToTranslate = true;
    private transient int lineNumber;
    private transient int charPosition;
    private String fileName;
    private Map<YangSchemaNodeIdentifier, YangSchemaNodeContextInfo> ysnContextInfoMap;
    private int mandatoryChildCount;
    private YangRevision revision;
    private Map<YangSchemaNodeIdentifier, YangSchemaNode> defaultChildMap;
    private boolean isDescendantNodeAugmented;
    private YangNode referredSchemaNode;
    private static final String E_NONDATA = "Method called for other then data node";

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    private YangNode() {
    }

    protected YangNode(YangNodeType type, Map<YangSchemaNodeIdentifier, YangSchemaNodeContextInfo> ysnContextInfoMap, DataNode.Type dtype) {
        this.nodeType = type;
        this.dataNodeType = dtype;
        this.ysnContextInfoMap = ysnContextInfoMap;
    }

    protected YangNode(YangNodeType type, Map<YangSchemaNodeIdentifier, YangSchemaNodeContextInfo> ysnContextInfoMap) {
        this.nodeType = type;
        this.ysnContextInfoMap = ysnContextInfoMap;
    }

    public boolean isDescendantNodeAugmented() {
        return this.isDescendantNodeAugmented;
    }

    public void setDescendantNodeAugmented(boolean descendantNodeAugmented) {
        this.isDescendantNodeAugmented = descendantNodeAugmented;
    }

    public YangNodeType getNodeType() {
        return this.nodeType;
    }

    private void setNodeType(YangNodeType nodeType) {
        this.nodeType = nodeType;
    }

    public YangNode getParent() {
        return this.parent;
    }

    public void setParent(YangNode parent) {
        this.parent = parent;
    }

    public YangNode getChild() {
        return this.child;
    }

    public void setChild(YangNode child) {
        this.child = child;
    }

    public YangNode getNextSibling() {
        return this.nextSibling;
    }

    public void setNextSibling(YangNode sibling) {
        this.nextSibling = sibling;
    }

    public YangNode getPreviousSibling() {
        return this.previousSibling;
    }

    public void setPreviousSibling(YangNode previousSibling) {
        this.previousSibling = previousSibling;
    }

    public void addChild(YangNode newChild) throws DataModelException {
        if (newChild.getNodeType() == null) {
            throw new DataModelException("Abstract node cannot be inserted into a tree " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        if (newChild.getParent() == null) {
            newChild.setParent(this);
            if (this instanceof RpcNotificationContainer) {
                ((RpcNotificationContainer)((Object)this)).addToIdentityTypedefMap(YangIoUtils.getCamelCase(newChild.getName(), null), newChild);
            }
        } else if (newChild.getParent() != this) {
            throw new DataModelException("Node is already part of a tree " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        if (newChild.getChild() != null) {
            throw new DataModelException("Child to be added is not atomic, it already has a child " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        if (newChild.getNextSibling() != null) {
            throw new DataModelException("Child to be added is not atomic, it already has a next sibling " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        if (newChild.getPreviousSibling() != null) {
            throw new DataModelException("Child to be added is not atomic, it already has a previous sibling " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        if (this.getChild() == null) {
            this.setChild(newChild);
        } else {
            YangNode curNode = this.getChild();
            while (curNode.getNextSibling() != null) {
                curNode = curNode.getNextSibling();
            }
            if (curNode.getNextSibling() == null) {
                curNode.setNextSibling(newChild);
                newChild.setPreviousSibling(curNode);
            }
        }
    }

    protected void processAdditionOfSchemaNodeToParentMap(String name, YangNamespace namespace) {
        this.processAdditionOfSchemaNodeToMap(name, namespace, this, this.getParent());
    }

    public void processAdditionOfSchemaNodeToCurNodeMap(String name, YangNamespace namespace, YangSchemaNode yangSchemaNode) {
        this.processAdditionOfSchemaNodeToMap(name, namespace, yangSchemaNode, this);
    }

    private void processAdditionOfSchemaNodeToMap(String name, YangNamespace namespace, YangSchemaNode yangSchemaNode, YangNode childSchemaMapHolder) {
        YangSchemaNodeIdentifier yangSchemaNodeIdentifier = new YangSchemaNodeIdentifier();
        yangSchemaNodeIdentifier.setName(name);
        yangSchemaNodeIdentifier.setNameSpace(namespace);
        YangSchemaNodeContextInfo yangSchemaNodeContextInfo = new YangSchemaNodeContextInfo();
        yangSchemaNodeContextInfo.setSchemaNode(yangSchemaNode);
        try {
            childSchemaMapHolder.addToChildSchemaMap(yangSchemaNodeIdentifier, yangSchemaNodeContextInfo);
        }
        catch (DataModelException dataModelException) {
            // empty catch block
        }
    }

    @Override
    public int compareTo(YangNode otherNode) {
        if (this.priority == otherNode.getPriority()) {
            return 0;
        }
        return Integer.valueOf(otherNode.getPriority()).compareTo(this.priority);
    }

    public YangNode clone(YangUses yangUses, boolean isDeviation) throws CloneNotSupportedException {
        YangNode clonedNode = (YangNode)super.clone();
        if (clonedNode instanceof YangLeavesHolder) {
            try {
                DataModelUtils.cloneListOfLeaf((YangLeavesHolder)((Object)clonedNode), yangUses, isDeviation);
                DataModelUtils.cloneListOfLeafList((YangLeavesHolder)((Object)clonedNode), yangUses, isDeviation);
            }
            catch (DataModelException e) {
                throw new CloneNotSupportedException(e.getMessage());
            }
        }
        clonedNode.setParent(null);
        clonedNode.setChild(null);
        clonedNode.setNextSibling(null);
        clonedNode.setPreviousSibling(null);
        if (!isDeviation) {
            clonedNode.yangSchemaNodeIdentifier = clonedNode.yangSchemaNodeIdentifier.clone();
            clonedNode.ysnContextInfoMap = new HashMap<YangSchemaNodeIdentifier, YangSchemaNodeContextInfo>();
            clonedNode.referredSchemaNode = this;
        }
        if (clonedNode instanceof YangAugmentableNode) {
            ((YangAugmentableNode)((Object)clonedNode)).cloneAugmentInfo();
        }
        return clonedNode;
    }

    public static void cloneSubTree(YangNode srcRootNode, YangNode dstRootNode, YangUses yangUses, boolean isDeviation) throws DataModelException {
        YangNode nextNodeToClone = srcRootNode;
        YangNode clonedTreeCurNode = dstRootNode;
        YangNode newNode = null;
        if ((nextNodeToClone = nextNodeToClone.getChild()) == null) {
            return;
        }
        TraversalType curTraversal = TraversalType.CHILD;
        try {
            while (nextNodeToClone != srcRootNode) {
                if (nextNodeToClone == null) {
                    throw new DataModelException("Internal error: Cloning failed, source tree null pointer reached " + nextNodeToClone.getName() + " in " + nextNodeToClone.getLineNumber() + " at " + nextNodeToClone.getCharPosition() + " in " + nextNodeToClone.getFileName() + "\"");
                }
                if (curTraversal != TraversalType.PARENT) {
                    newNode = nextNodeToClone.clone(yangUses, isDeviation);
                    if (newNode instanceof YangUses) {
                        ((YangUses)newNode).setCloned(true);
                    }
                    YangNode.detectCollisionWhileCloning(clonedTreeCurNode, newNode, curTraversal);
                }
                if (curTraversal == TraversalType.CHILD) {
                    clonedTreeCurNode.addChild(newNode);
                    clonedTreeCurNode = newNode;
                } else if (curTraversal == TraversalType.SIBLING) {
                    clonedTreeCurNode.addNextSibling(newNode);
                    clonedTreeCurNode = newNode;
                } else {
                    if (clonedTreeCurNode instanceof YangLeavesHolder) {
                        DataModelUtils.updateClonedLeavesUnionEnumRef((YangLeavesHolder)((Object)clonedTreeCurNode));
                    }
                    clonedTreeCurNode = clonedTreeCurNode.getParent();
                }
                if (curTraversal != TraversalType.PARENT && clonedTreeCurNode instanceof YangAugment && clonedTreeCurNode.getParent() instanceof YangUses) {
                    YangAugment augment = (YangAugment)clonedTreeCurNode;
                    DataModelUtils.addUnresolvedAugment(yangUses, augment);
                }
                if (curTraversal != TraversalType.PARENT && nextNodeToClone.getChild() != null) {
                    curTraversal = TraversalType.CHILD;
                    nextNodeToClone = nextNodeToClone.getChild();
                    continue;
                }
                if (nextNodeToClone.getNextSibling() != null) {
                    curTraversal = TraversalType.SIBLING;
                    nextNodeToClone = nextNodeToClone.getNextSibling();
                    continue;
                }
                curTraversal = TraversalType.PARENT;
                nextNodeToClone = nextNodeToClone.getParent();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new DataModelException("Failed to clone the tree " + nextNodeToClone.getName() + " in " + nextNodeToClone.getLineNumber() + " at " + nextNodeToClone.getCharPosition() + " in " + nextNodeToClone.getFileName() + "\"");
        }
    }

    private static void detectCollisionWhileCloning(YangNode currentNode, YangNode newNode, TraversalType addAs) throws DataModelException {
        if (!(currentNode instanceof CollisionDetector) || !(newNode instanceof Parsable)) {
            throw new DataModelException("Node in data model tree does not support collision detection " + newNode.getName() + " in " + newNode.getLineNumber() + " at " + newNode.getCharPosition() + " in " + newNode.getFileName() + "\"");
        }
        CollisionDetector collisionDetector = (CollisionDetector)((Object)currentNode);
        Parsable parsable = (Parsable)((Object)newNode);
        if (addAs == TraversalType.CHILD) {
            collisionDetector.detectCollidingChild(newNode.getName(), parsable.getYangConstructType());
        } else if (addAs == TraversalType.SIBLING) {
            if (!((currentNode = currentNode.getParent()) instanceof CollisionDetector)) {
                throw new DataModelException("Node in data model tree does not support collision detection" + currentNode.getName() + " in " + currentNode.getLineNumber() + " at " + currentNode.getCharPosition() + " in " + currentNode.getFileName() + "\"");
            }
            collisionDetector = (CollisionDetector)((Object)currentNode);
            collisionDetector.detectCollidingChild(newNode.getName(), parsable.getYangConstructType());
        } else {
            throw new DataModelException("Error tree cloning " + currentNode.getName() + " in " + currentNode.getLineNumber() + " at " + currentNode.getCharPosition() + " in " + currentNode.getFileName() + "\"");
        }
    }

    public boolean isToTranslate() {
        return this.isToTranslate;
    }

    public void setToTranslate(boolean toTranslate) {
        this.isToTranslate = toTranslate;
    }

    private void addNextSibling(YangNode newSibling) throws DataModelException {
        if (newSibling.getNodeType() == null) {
            throw new DataModelException("Cloned abstract node cannot be inserted into a tree " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        if (newSibling.getParent() != null) {
            throw new DataModelException("Node is already part of a tree, and cannot be added as a sibling " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        newSibling.setParent(this.getParent());
        if (newSibling.getPreviousSibling() != null) {
            throw new DataModelException("New sibling to be added is not atomic, it already has a previous sibling " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        newSibling.setPreviousSibling(this);
        this.setNextSibling(newSibling);
        if (newSibling.getChild() != null) {
            throw new DataModelException("Sibling to be added is not atomic, it already has a child " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
        if (newSibling.getNextSibling() != null) {
            throw new DataModelException("Sibling to be added is not atomic, it already has a next sibling " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
        }
    }

    @Override
    public YangSchemaNodeContextInfo getChildSchema(YangSchemaNodeIdentifier dataNodeIdentifier) throws DataModelException {
        YangSchemaNodeContextInfo childSchemaContext = this.ysnContextInfoMap.get(dataNodeIdentifier);
        if (childSchemaContext == null) {
            throw new DataModelException("Requested " + dataNodeIdentifier.getName() + " is not child in " + this.getName());
        }
        return childSchemaContext;
    }

    @Override
    public int getMandatoryChildCount() throws DataModelException {
        return this.mandatoryChildCount;
    }

    @Override
    public Map<YangSchemaNodeIdentifier, YangSchemaNode> getDefaultChild(YangSchemaNodeIdentifier dataNodeIdentifier) {
        return this.defaultChildMap;
    }

    @Override
    public boolean isNotificationPresent() throws DataModelException {
        throw new DataModelException("Method is called for node other than module/sub-module.");
    }

    @Override
    public boolean isRpcPresent() throws DataModelException {
        throw new DataModelException("Method is called for node other than module/sub-module.");
    }

    @Override
    public boolean isEmptyDataType() throws DataModelException {
        throw new DataModelException("Method is called for node other than leaf/leaf-list.");
    }

    public abstract void addToChildSchemaMap(YangSchemaNodeIdentifier var1, YangSchemaNodeContextInfo var2) throws DataModelException;

    public abstract void incrementMandatoryChildCount();

    public void setMandatoryChildCount(int mandatoryChildCount) {
        this.mandatoryChildCount = mandatoryChildCount;
    }

    public abstract void addToDefaultChildMap(YangSchemaNodeIdentifier var1, YangSchemaNode var2);

    public Map<YangSchemaNodeIdentifier, YangSchemaNode> getDefaultChildMap() {
        return this.defaultChildMap;
    }

    public Map<YangSchemaNodeIdentifier, YangSchemaNodeContextInfo> getYsnContextInfoMap() {
        return this.ysnContextInfoMap;
    }

    public void setNameSpaceAndAddToParentSchemaMap() {
        if (this.getParent() != null) {
            this.setNameSpace(this.getParent().getNameSpace());
            this.processAdditionOfSchemaNodeToParentMap(this.getName(), this.getNameSpace());
        } else {
            this.setNameSpace((YangNamespace)((Object)this));
        }
        if (this instanceof YangLeavesHolder) {
            ((YangLeavesHolder)((Object)this)).setLeafNameSpaceAndAddToParentSchemaMap();
        }
    }

    public void setYsnContextInfoMap(Map<YangSchemaNodeIdentifier, YangSchemaNodeContextInfo> ysnContextInfoMap) {
        this.ysnContextInfoMap = ysnContextInfoMap;
    }

    public void addToYsnContextInfoMap(YangSchemaNodeIdentifier id, YangSchemaNodeContextInfo info) {
        this.getYsnContextInfoMap().put(id, info);
    }

    @Override
    public void isValueValid(String value) throws DataModelException {
        throw new DataModelException("Value validation asked for YANG node. " + this.getName() + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName() + "\"");
    }

    @Override
    public YangSchemaNodeIdentifier getYangSchemaNodeIdentifier() {
        return this.yangSchemaNodeIdentifier;
    }

    public void setYangSchemaNodeIdentifier(YangSchemaNodeIdentifier id) {
        if (this.yangSchemaNodeIdentifier == null) {
            this.yangSchemaNodeIdentifier = new YangSchemaNodeIdentifier();
        }
        this.yangSchemaNodeIdentifier = id;
    }

    @Override
    public String getName() {
        return this.yangSchemaNodeIdentifier.getName();
    }

    public void setName(String name) {
        if (this.yangSchemaNodeIdentifier == null) {
            this.yangSchemaNodeIdentifier = new YangSchemaNodeIdentifier();
        }
        this.yangSchemaNodeIdentifier.setName(name);
    }

    @Override
    public YangNamespace getNameSpace() {
        return this.yangSchemaNodeIdentifier.getNameSpace();
    }

    public void setNameSpace(YangNamespace namespace) {
        if (this.yangSchemaNodeIdentifier == null) {
            this.yangSchemaNodeIdentifier = new YangSchemaNodeIdentifier();
        }
        this.yangSchemaNodeIdentifier.setNameSpace(namespace);
    }

    public YangRevision getRevision() {
        return this.revision;
    }

    public void setRevision(YangRevision revision) {
        this.revision = revision;
    }

    @Override
    public YangSchemaNode getNotificationSchemaNode(String notificationNameInEnum) throws DataModelException {
        throw new DataModelException("Method called for schema node other then module/sub-module");
    }

    @Override
    public YangSchemaNode getReferredSchema() {
        return this.referredSchemaNode;
    }

    public boolean isOpTypeReq() {
        return this instanceof RpcNotificationContainer || !(this instanceof InvalidOpTypeHolder) && this.getParent().isOpTypeReq();
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getCharPosition() {
        return this.charPosition;
    }

    @Override
    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public void setCharPosition(int charPositionInLine) {
        this.charPosition = charPositionInLine;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String name) {
        this.fileName = name;
    }

    public SchemaId getSchemaId() throws IllegalArgumentException {
        if (this.schemaId == null) {
            throw new IllegalArgumentException(E_NONDATA);
        }
        return this.schemaId;
    }

    public DataNode.Type getType() throws IllegalArgumentException {
        if (this.dataNodeType == null) {
            throw new IllegalArgumentException(E_NONDATA);
        }
        return this.dataNodeType;
    }

    public SchemaContext getParentContext() throws IllegalArgumentException {
        if (this.parentContext == null) {
            throw new IllegalArgumentException(E_NONDATA);
        }
        return this.parentContext;
    }

    public void setParentContext() {
        if (this instanceof SchemaDataNode) {
            this.parentContext = DataModelUtils.getParentSchemaContext(this.getParent());
            if (this.nodeType != YangNodeType.RPC_NODE) {
                ((YangLeavesHolder)((Object)this)).setLeafParentContext();
            }
            this.schemaId = new SchemaId(this.getName(), this.getNameSpace().getModuleNamespace());
        } else if (this instanceof YangCase || this instanceof YangAugment) {
            ((YangLeavesHolder)((Object)this)).setLeafParentContext();
        }
    }

    public void setParentContext(SchemaContext schemaContext) {
        this.parentContext = schemaContext;
    }

    @Override
    public void setRootContext(SchemaContext context) {
        this.parentContext = context;
    }

    public void setLeafRootContext(SchemaContext context) {
        for (YangLeaf yangLeaf : ((YangLeavesHolder)((Object)this)).getListOfLeaf()) {
            yangLeaf.setParentContext(context);
        }
        for (YangLeafList yangLeafList : ((YangLeavesHolder)((Object)this)).getListOfLeafList()) {
            yangLeafList.setParentContext(context);
        }
    }
}

