/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangBase;
import org.onosproject.yang.compiler.datamodel.YangIdentity;
import org.onosproject.yang.compiler.datamodel.YangIdentityRef;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.DataModelUtils;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.linker.impl.YangResolutionInfoImpl;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;

public final class BaseListener {
    private BaseListener() {
    }

    public static void processBaseEntry(TreeWalkListener listener, GeneratedYangParser.BaseStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.BASE_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY);
        YangNodeIdentifier nodeIdentifier = ListenerUtil.getValidNodeIdentifier(ctx.string().getText(), YangConstructType.BASE_DATA, ctx);
        Parsable tmpData = listener.getParsedDataStack().peek();
        if (tmpData instanceof YangIdentityRef) {
            return;
        }
        if (!(tmpData instanceof YangIdentity)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.BASE_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY));
        }
        YangBase yangBase = new YangBase();
        yangBase.setBaseIdentifier(nodeIdentifier);
        ((YangIdentity)tmpData).setBaseNode(yangBase);
        yangBase.setParentIdentity((YangIdentity)tmpData);
        int errorLine = ctx.getStart().getLine();
        int errorPosition = ctx.getStart().getCharPositionInLine();
        yangBase.setLineNumber(errorLine);
        yangBase.setCharPosition(errorPosition);
        yangBase.setFileName(listener.getFileName());
        YangResolutionInfoImpl<YangBase> resolutionInfo = new YangResolutionInfoImpl<YangBase>(yangBase, (YangNode)((Object)tmpData), errorLine, errorPosition);
        BaseListener.addToResolutionList(resolutionInfo, ctx);
    }

    private static void addToResolutionList(YangResolutionInfoImpl<YangBase> resolutionInfo, GeneratedYangParser.BaseStatementContext ctx) {
        try {
            DataModelUtils.addResolutionInfo(resolutionInfo);
        }
        catch (DataModelException e) {
            throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.BASE_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT, e.getMessage()));
        }
    }
}

