/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangAugment;
import org.onosproject.yang.compiler.datamodel.YangCase;
import org.onosproject.yang.compiler.datamodel.YangContainer;
import org.onosproject.yang.compiler.datamodel.YangGrouping;
import org.onosproject.yang.compiler.datamodel.YangInput;
import org.onosproject.yang.compiler.datamodel.YangList;
import org.onosproject.yang.compiler.datamodel.YangModule;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNotification;
import org.onosproject.yang.compiler.datamodel.YangOutput;
import org.onosproject.yang.compiler.datamodel.YangSubModule;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.GeneratedLanguage;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerCollisionDetector;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yang.compiler.translator.tojava.YangDataModelFactory;

public final class ListListener {
    private ListListener() {
    }

    public static void processListEntry(TreeWalkListener listener, GeneratedYangParser.ListStatementContext ctx) {
        Parsable curData;
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.LIST_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.LIST_DATA, ctx);
        ListListener.validateSubStatementsCardinality(ctx);
        int line = ctx.getStart().getLine();
        int charPositionInLine = ctx.getStart().getCharPositionInLine();
        ListenerCollisionDetector.detectCollidingChildUtil(listener, line, charPositionInLine, identifier, YangConstructType.LIST_DATA);
        YangList yangList = YangDataModelFactory.getYangListNode(GeneratedLanguage.JAVA_GENERATION);
        yangList.setName(identifier);
        yangList.setLineNumber(line);
        yangList.setCharPosition(charPositionInLine);
        yangList.setFileName(listener.getFileName());
        if (ctx.configStatement().isEmpty()) {
            boolean parentConfig = ListenerValidation.getParentNodeConfig(listener);
            yangList.setConfig(parentConfig);
        }
        if ((curData = listener.getParsedDataStack().peek()) instanceof YangModule || curData instanceof YangContainer || curData instanceof YangList || curData instanceof YangCase || curData instanceof YangNotification || curData instanceof YangInput || curData instanceof YangOutput || curData instanceof YangAugment || curData instanceof YangGrouping || curData instanceof YangSubModule) {
            YangNode curNode = (YangNode)((Object)curData);
            try {
                curNode.addChild(yangList);
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY, e.getMessage()));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.LIST_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push(yangList);
    }

    public static void processListExit(TreeWalkListener listener, GeneratedYangParser.ListStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.LIST_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
        if (listener.getParsedDataStack().peek() instanceof YangList) {
            YangList yangList = (YangList)listener.getParsedDataStack().peek();
            try {
                yangList.validateDataOnExit();
                ListenerUtil.addUniqueHolderToRoot(yangList);
            }
            catch (DataModelException e) {
                ParserException exc = new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT, e.getMessage()));
                exc.setLine(ctx.getStart().getLine());
                exc.setCharPosition(ctx.getStart().getCharPositionInLine());
                throw exc;
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.LIST_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }

    private static void validateSubStatementsCardinality(GeneratedYangParser.ListStatementContext ctx) {
        ListenerValidation.validateCardinalityMaxOne(ctx.keyStatement(), YangConstructType.KEY_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.configStatement(), YangConstructType.CONFIG_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.maxElementsStatement(), YangConstructType.MAX_ELEMENT_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.minElementsStatement(), YangConstructType.MIN_ELEMENT_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.descriptionStatement(), YangConstructType.DESCRIPTION_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.referenceStatement(), YangConstructType.REFERENCE_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.statusStatement(), YangConstructType.STATUS_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityNonZero(ctx.dataDefStatement(), YangConstructType.DATA_DEF_DATA, YangConstructType.LIST_DATA, ctx.identifier().getText(), ctx);
    }
}

