/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangMust;
import org.onosproject.yang.compiler.datamodel.YangMustHolder;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;

public final class MustListener {
    private MustListener() {
    }

    public static void processMustEntry(TreeWalkListener listener, GeneratedYangParser.MustStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.MUST_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY);
        String constraint = ListenerUtil.removeQuotesAndHandleConcat(ctx.string().getText());
        Parsable tmpNode = listener.getParsedDataStack().peek();
        if (!(tmpNode instanceof YangMustHolder)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.MUST_DATA, ctx.string().getText(), ListenerErrorLocation.ENTRY));
        }
        YangMust must = new YangMust();
        must.setConstraint(constraint);
        must.setLineNumber(ctx.getStart().getLine());
        must.setCharPosition(ctx.getStart().getCharPositionInLine());
        must.setFileName(listener.getFileName());
        YangMustHolder mustHolder = (YangMustHolder)((Object)tmpNode);
        mustHolder.addMust(must);
        listener.getParsedDataStack().push(must);
    }

    public static void processMustExit(TreeWalkListener listener, GeneratedYangParser.MustStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.MUST_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT);
        if (!(listener.getParsedDataStack().peek() instanceof YangMust)) {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.MUST_DATA, ctx.string().getText(), ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }
}

