/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.compiler.parser.impl.listeners;

import org.onosproject.yang.compiler.datamodel.YangContainer;
import org.onosproject.yang.compiler.datamodel.YangGrouping;
import org.onosproject.yang.compiler.datamodel.YangInput;
import org.onosproject.yang.compiler.datamodel.YangList;
import org.onosproject.yang.compiler.datamodel.YangModule;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangNotification;
import org.onosproject.yang.compiler.datamodel.YangOutput;
import org.onosproject.yang.compiler.datamodel.YangRpc;
import org.onosproject.yang.compiler.datamodel.YangSubModule;
import org.onosproject.yang.compiler.datamodel.YangTypeDef;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.compiler.datamodel.utils.GeneratedLanguage;
import org.onosproject.yang.compiler.datamodel.utils.Parsable;
import org.onosproject.yang.compiler.datamodel.utils.YangConstructType;
import org.onosproject.yang.compiler.parser.antlrgencode.GeneratedYangParser;
import org.onosproject.yang.compiler.parser.exceptions.ParserException;
import org.onosproject.yang.compiler.parser.impl.TreeWalkListener;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerCollisionDetector;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorLocation;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorMessageConstruction;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerErrorType;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerUtil;
import org.onosproject.yang.compiler.parser.impl.parserutils.ListenerValidation;
import org.onosproject.yang.compiler.translator.tojava.YangDataModelFactory;

public final class TypeDefListener {
    private TypeDefListener() {
    }

    public static void processTypeDefEntry(TreeWalkListener listener, GeneratedYangParser.TypedefStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY);
        String identifier = ListenerUtil.getValidIdentifier(ctx.identifier().getText(), YangConstructType.TYPEDEF_DATA, ctx);
        TypeDefListener.validateSubStatementsCardinality(ctx);
        int line = ctx.getStart().getLine();
        int charPositionInLine = ctx.getStart().getCharPositionInLine();
        ListenerCollisionDetector.detectCollidingChildUtil(listener, line, charPositionInLine, identifier, YangConstructType.TYPEDEF_DATA);
        YangTypeDef typeDefNode = YangDataModelFactory.getYangTypeDefNode(GeneratedLanguage.JAVA_GENERATION);
        typeDefNode.setName(identifier);
        typeDefNode.setLineNumber(ctx.getStart().getLine());
        typeDefNode.setCharPosition(ctx.getStart().getCharPositionInLine());
        typeDefNode.setFileName(listener.getFileName());
        Parsable curData = listener.getParsedDataStack().peek();
        if (curData instanceof YangModule || curData instanceof YangSubModule || curData instanceof YangContainer || curData instanceof YangList || curData instanceof YangNotification || curData instanceof YangRpc || curData instanceof YangInput || curData instanceof YangOutput || curData instanceof YangGrouping) {
            YangNode curNode = (YangNode)((Object)curData);
            try {
                curNode.addChild(typeDefNode);
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructExtendedListenerErrorMessage(ListenerErrorType.UNHANDLED_PARSED_DATA, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY, e.getMessage()));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_HOLDER, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText(), ListenerErrorLocation.ENTRY));
        }
        listener.getParsedDataStack().push(typeDefNode);
    }

    public static void processTypeDefExit(TreeWalkListener listener, GeneratedYangParser.TypedefStatementContext ctx) {
        ListenerValidation.checkStackIsNotEmpty(listener, ListenerErrorType.MISSING_HOLDER, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT);
        if (listener.getParsedDataStack().peek() instanceof YangTypeDef) {
            YangTypeDef typeDefNode = (YangTypeDef)listener.getParsedDataStack().peek();
            try {
                typeDefNode.validateDataOnExit();
            }
            catch (DataModelException e) {
                throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.INVALID_CONTENT, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
            }
        } else {
            throw new ParserException(ListenerErrorMessageConstruction.constructListenerErrorMessage(ListenerErrorType.MISSING_CURRENT_HOLDER, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText(), ListenerErrorLocation.EXIT));
        }
        listener.getParsedDataStack().pop();
    }

    private static void validateSubStatementsCardinality(GeneratedYangParser.TypedefStatementContext ctx) {
        ListenerValidation.validateCardinalityMaxOne(ctx.unitsStatement(), YangConstructType.UNITS_DATA, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.defaultStatement(), YangConstructType.DEFAULT_DATA, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityEqualsOne(ctx.typeStatement(), YangConstructType.TYPE_DATA, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText(), ctx);
        ListenerValidation.validateCardinalityMaxOne(ctx.descriptionStatement(), YangConstructType.DESCRIPTION_DATA, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.referenceStatement(), YangConstructType.REFERENCE_DATA, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText());
        ListenerValidation.validateCardinalityMaxOne(ctx.statusStatement(), YangConstructType.STATUS_DATA, YangConstructType.TYPEDEF_DATA, ctx.identifier().getText());
    }
}

