/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.helperutils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.tool.YangCompilerManager;
import org.onosproject.yang.model.YangModel;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YangApacheUtils {
    private static final String SLASH = File.separator;
    private static final String HYPHEN = "-";
    private static final String PERIOD = ".";
    private static final String YANG_RESOURCES = "yang/resources";
    private static final String SYSTEM = SLASH + "system" + SLASH;
    private static final String MAVEN = "mvn:";
    private static final String JAR = ".jar";
    private static final String USER_DIRECTORY = "user.dir";
    private static final Logger log = LoggerFactory.getLogger(YangApacheUtils.class);

    private YangApacheUtils() {
    }

    public static YangModel getYangModel(Class<?> modClass) {
        BundleContext context = FrameworkUtil.getBundle(modClass).getBundleContext();
        if (context != null) {
            Bundle bundle = context.getBundle();
            ArrayList<YangNode> curNodes = new ArrayList<YangNode>();
            String jarPath = YangApacheUtils.getJarPathFromBundleLocation(bundle.getLocation(), context.getProperty(USER_DIRECTORY));
            String metaPath = jarPath + SLASH + YANG_RESOURCES + SLASH;
            YangModel model = YangApacheUtils.processJarParsingOperations(jarPath);
            if (model != null) {
                curNodes.addAll(YangCompilerManager.getYangNodes(model));
                if (!curNodes.isEmpty()) {
                    try {
                        return YangCompilerManager.processYangModel(metaPath, curNodes, model.getYangModelId(), false);
                    }
                    catch (IOException e) {
                        log.error(" failed to create process YANG model " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return null;
    }

    private static String getJarPathFromBundleLocation(String mvnLocationPath, String currentDirectory) {
        String[] split;
        String[] strArray;
        StringBuilder builder = new StringBuilder();
        builder.append(currentDirectory).append(SYSTEM);
        StringBuilder ver = new StringBuilder();
        if (mvnLocationPath.contains(MAVEN) && (strArray = mvnLocationPath.replaceFirst("\\$Bundle-.*$", "").split(MAVEN))[1].contains(File.separator) && (split = strArray[1].split(File.separator))[0].contains(PERIOD)) {
            String[] groupId;
            for (String s : groupId = split[0].split(Pattern.quote(PERIOD))) {
                builder.append(s).append(SLASH);
            }
            for (int i = 1; i < split.length; ++i) {
                builder.append(split[i]).append(SLASH);
                ver.append(split[i]).append(HYPHEN);
            }
            builder.append((CharSequence)ver);
            builder.deleteCharAt(builder.length() - 1);
            return builder.toString();
        }
        return null;
    }

    private static YangModel processJarParsingOperations(String path) {
        String jar = path + JAR;
        try {
            File file = new File(jar);
            if (file.exists()) {
                return YangCompilerManager.parseJarFile(path + JAR, path);
            }
        }
        catch (IOException e) {
            log.error(" failed to parse the jar file in path {} : {} ", (Object)path, (Object)e.getMessage());
        }
        return null;
    }
}

