/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.impl;

import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.model.NodeKey;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.model.RpcContext;
import org.onosproject.yang.model.SchemaContext;
import org.onosproject.yang.model.SchemaContextProvider;
import org.onosproject.yang.model.SchemaId;
import org.onosproject.yang.runtime.RuntimeHelper;
import org.onosproject.yang.runtime.impl.DefaultYangModelRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchemaContextProvider
implements SchemaContextProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultSchemaContextProvider.class);
    public DefaultYangModelRegistry reg;

    public DefaultSchemaContextProvider(DefaultYangModelRegistry registry) {
        this.reg = registry;
    }

    public SchemaContext getSchemaContext(ResourceId id) {
        return null;
    }

    public RpcContext getRpcContext(ResourceId id) {
        SchemaId schemaId = ((NodeKey)id.nodeKeys().get(1)).schemaId();
        SchemaContext childContext = this.reg.getChildContext(schemaId);
        if (childContext == null) {
            throw new IllegalArgumentException("Module is not registered or RPC name doesn't exist in module.");
        }
        YangSchemaNode childNode = (YangSchemaNode)childContext;
        String rpcname = childNode.getJavaAttributeName();
        YangSchemaNode moduleNode = (YangSchemaNode)((Object)childNode.getNameSpace());
        String pkg = moduleNode.getJavaPackage();
        String moduleClassName = moduleNode.getJavaClassNameOrBuiltInType();
        String moduleQlName = pkg + "." + RuntimeHelper.getCapitalCase(moduleClassName);
        Class<?> moduleClass = this.reg.getRegisteredClass(moduleNode);
        ClassLoader classLoader = moduleClass.getClassLoader();
        Class<?> rpcServiceIntf = null;
        try {
            rpcServiceIntf = classLoader.loadClass(moduleQlName + "Service");
        }
        catch (ClassNotFoundException e) {
            log.error("Not able to load service interface class");
        }
        return new RpcContext(rpcname, rpcServiceIntf);
    }
}

