/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.onosproject.yang.compiler.datamodel.YangNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.tool.YangCompilerManager;
import org.onosproject.yang.compiler.utils.io.impl.YangIoUtils;
import org.onosproject.yang.model.YangModel;
import org.onosproject.yang.runtime.DefaultModelRegistrationParam;
import org.onosproject.yang.runtime.ModelRegistrationParam;
import org.onosproject.yang.runtime.RuntimeHelper;
import org.onosproject.yang.runtime.impl.DefaultYangModelRegistry;

public final class MockYangSchemaNodeProvider {
    private static final String FS = File.separator;
    private static final String PATH = System.getProperty("user.dir") + FS + "target" + FS + "classes" + FS;
    private static final String SER_FILE_PATH = "yang" + FS + "resources" + FS + "YangMetaData.ser";
    private static final String META_PATH = PATH + SER_FILE_PATH;
    private static final String TEMP_FOLDER_PATH = PATH + "Temp";
    private static DefaultYangModelRegistry reg;
    private static List<YangNode> nodes;
    private static String id;

    private MockYangSchemaNodeProvider() {
    }

    public static void processSchemaRegistry() {
        try {
            reg = new DefaultYangModelRegistry();
            YangModel model = YangCompilerManager.deSerializeDataModel(META_PATH);
            Set<YangNode> appNode = YangCompilerManager.getYangNodes(model);
            nodes.addAll(appNode);
            id = model.getYangModelId();
            reg.registerModel(MockYangSchemaNodeProvider.param(nodes));
            MockYangSchemaNodeProvider.addClassInfo(nodes);
            YangIoUtils.deleteDirectory(TEMP_FOLDER_PATH);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void unRegister(List<YangNode> nodes) {
        reg.unregisterModel(MockYangSchemaNodeProvider.param(nodes));
    }

    private static ModelRegistrationParam param(List<YangNode> nodes) {
        DefaultModelRegistrationParam.Builder b = DefaultModelRegistrationParam.builder();
        YangModel model = null;
        try {
            model = YangCompilerManager.processYangModel(META_PATH, nodes, id, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        b.setYangModel(model);
        return b.build();
    }

    static YangModel processModelTest() {
        YangModel model = null;
        try {
            model = YangCompilerManager.deSerializeDataModel(META_PATH);
            Set<YangNode> appNode = YangCompilerManager.getYangNodes(model);
            ArrayList<YangNode> nodes = new ArrayList<YangNode>();
            nodes.addAll(appNode);
            return YangCompilerManager.processYangModel(META_PATH, nodes, id, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            return model;
        }
    }

    private static void addClassInfo(List<YangNode> nodes) {
        ClassLoader classLoader = MockYangSchemaNodeProvider.class.getClassLoader();
        for (YangSchemaNode yangSchemaNode : nodes) {
            Class<?> cls;
            String appName = RuntimeHelper.getInterfaceClassName(yangSchemaNode);
            try {
                cls = classLoader.loadClass(appName);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            reg.addRegClass(appName, cls);
        }
    }

    public static DefaultYangModelRegistry registry() {
        return reg;
    }

    public static void addMockNode(YangSchemaNode node, String name) {
        reg.processApplicationContext(node, name);
    }

    static {
        nodes = new ArrayList<YangNode>();
    }
}

