/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.runtime.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import org.onosproject.yang.compiler.datamodel.YangSchemaNode;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeContextInfo;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeIdentifier;
import org.onosproject.yang.compiler.datamodel.YangSchemaNodeType;
import org.onosproject.yang.compiler.datamodel.exceptions.DataModelException;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.runtime.YangModelRegistry;
import org.onosproject.yang.runtime.impl.DefaultYangModelRegistry;
import org.onosproject.yang.runtime.impl.ModelConverterException;
import org.onosproject.yang.runtime.impl.YobUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class YobWorkBench {
    private static final Logger log = LoggerFactory.getLogger(YobWorkBench.class);
    private ClassLoader classLoader;
    private Map<YangSchemaNodeIdentifier, YobWorkBench> attributeMap = new HashMap<YangSchemaNodeIdentifier, YobWorkBench>();
    private Object builtObject;
    private String setterInParent;
    private YangSchemaNode schemaNode;

    YobWorkBench(ClassLoader classLoader, Object builtObject, String setterInParent, YangSchemaNode schemaNode) {
        this.classLoader = classLoader;
        this.setterInParent = setterInParent;
        this.builtObject = builtObject;
        this.schemaNode = schemaNode;
    }

    ClassLoader classLoader() {
        return this.classLoader;
    }

    void classLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    String setterInParent() {
        return this.setterInParent;
    }

    void setterInParent(String name) {
        this.setterInParent = name;
    }

    YangSchemaNode schemaNode() {
        return this.schemaNode;
    }

    void schemaNode(YangSchemaNode node) {
        this.schemaNode = node;
    }

    Map<YangSchemaNodeIdentifier, YobWorkBench> attributeMap() {
        return this.attributeMap;
    }

    void attributeMap(Map<YangSchemaNodeIdentifier, YobWorkBench> attributeMap) {
        this.attributeMap = attributeMap;
    }

    Object getBuiltObject() {
        return this.builtObject;
    }

    void setBuiltObject(Object obj) {
        this.builtObject = obj;
    }

    void setObject(YobWorkBench curWb, DataNode dataNode, DefaultYangModelRegistry reg) {
        Object parentObj = this.getParentObject(reg, curWb.schemaNode());
        YobWorkBench.setObjectInParent(parentObj, curWb.setterInParent(), curWb.getBuiltObject(), dataNode.type());
    }

    private static void setObjectInParent(Object parentObj, String setter, Object curObj, DataNode.Type type) {
        Class<?> parentClass = parentObj.getClass();
        String parentClassName = parentClass.getName();
        try {
            Method method;
            Class classType = null;
            Field fieldName = parentClass.getDeclaredField(setter);
            if (fieldName != null) {
                classType = fieldName.getType();
            }
            if (type == DataNode.Type.MULTI_INSTANCE_NODE) {
                if (fieldName != null) {
                    ParameterizedType genericTypes = (ParameterizedType)fieldName.getGenericType();
                    classType = (Class)genericTypes.getActualTypeArguments()[0];
                }
                method = parentClass.getDeclaredMethod("addTo" + YobUtils.getCapitalCase(setter), classType);
            } else {
                method = parentClass.getDeclaredMethod(setter, classType);
            }
            method.invoke(parentObj, curObj);
        }
        catch (NoSuchFieldException e) {
            log.error("Failed to get field for class: {}", (Object)parentClassName);
            throw new ModelConverterException("Failed to get field for class: " + parentClassName);
        }
        catch (NoSuchMethodException e) {
            log.error("Failed to get method for class: {}", (Object)parentClassName);
            throw new ModelConverterException("Failed to get method for class: " + parentClassName);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Failed to invoke method for class: {}", (Object)parentClassName);
            throw new ModelConverterException("Failed to invoke method for class: " + parentClassName);
        }
    }

    Object getParentObject(DefaultYangModelRegistry reg, YangSchemaNode schemaNode) {
        YangSchemaNode nonSchemaHolder;
        YangSchemaNodeIdentifier targetNode = schemaNode.getYangSchemaNodeIdentifier();
        YobWorkBench curWorkBench = this;
        do {
            YangSchemaNodeContextInfo schemaContext;
            YangSchemaNode parentSchema = null;
            try {
                parentSchema = curWorkBench.schemaNode();
                schemaContext = parentSchema.getChildSchema(targetNode);
            }
            catch (DataModelException e) {
                throw new ModelConverterException(parentSchema.getName() + " does not have child " + targetNode.getName(), e);
            }
            nonSchemaHolder = schemaContext.getContextSwitchedNode();
            if (nonSchemaHolder == null) continue;
            YangSchemaNodeIdentifier nonSchemaIdentifier = nonSchemaHolder.getYangSchemaNodeIdentifier();
            YobWorkBench childWorkBench = curWorkBench.attributeMap.get(nonSchemaIdentifier);
            if (childWorkBench == null) {
                YobWorkBench newWorkBench = YobWorkBench.getNewChildWorkBench(schemaContext, targetNode, curWorkBench, reg);
                curWorkBench.attributeMap.put(nonSchemaIdentifier, newWorkBench);
                curWorkBench = newWorkBench;
                continue;
            }
            curWorkBench = childWorkBench;
        } while (nonSchemaHolder != null);
        return curWorkBench.getBuiltObject();
    }

    static YobWorkBench getNewChildWorkBench(YangSchemaNodeContextInfo childContext, YangSchemaNodeIdentifier targetNode, YobWorkBench curWorkBench, DefaultYangModelRegistry registry) {
        String name;
        YangSchemaNode ctxSwitchedNode = childContext.getContextSwitchedNode();
        String setterInParent = ctxSwitchedNode.getJavaAttributeName();
        if (ctxSwitchedNode.getYangSchemaNodeType() == YangSchemaNodeType.YANG_CHOICE_NODE) {
            try {
                childContext = ctxSwitchedNode.getChildSchema(targetNode);
                ctxSwitchedNode = childContext.getContextSwitchedNode();
                name = YobUtils.getQualifiedDefaultClass(childContext.getContextSwitchedNode());
            }
            catch (DataModelException e) {
                throw new ModelConverterException(ctxSwitchedNode.getName() + " does not have child " + targetNode.getName(), e);
            }
        } else if (ctxSwitchedNode.getYangSchemaNodeType() == YangSchemaNodeType.YANG_AUGMENT_NODE) {
            name = YobUtils.getQualifiedDefaultClass(ctxSwitchedNode);
            setterInParent = YobUtils.getQualifiedinterface(ctxSwitchedNode);
        } else {
            name = YobUtils.getQualifiedDefaultClass(childContext.getSchemaNode());
        }
        ClassLoader newClassesLoader = YobUtils.getTargetClassLoader(curWorkBench.classLoader, childContext, registry);
        Object obj = YobUtils.getInstanceOfClass(newClassesLoader, name);
        return new YobWorkBench(newClassesLoader, obj, setterInParent, ctxSwitchedNode);
    }

    static void addInAugmentation(Object builder, Object instance) {
        Class<?> builderClass = builder.getClass();
        Class<?> baseClass = builderClass.getSuperclass();
        try {
            Method method = baseClass.getDeclaredMethod("addAugmentation", InnerModelObject.class);
            method.invoke(builder, instance);
        }
        catch (NoSuchMethodException e) {
            log.error("Failed to get method for class: {}", (Object)"addAugmentation");
            throw new ModelConverterException("Failed to get method for class: addAugmentation");
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Failed to invoke method for class: {}", (Object)"addAugmentation");
            throw new ModelConverterException("Failed to invoke method for class: addAugmentation");
        }
    }

    void buildNonSchemaAttributes(YangModelRegistry reg) {
        for (Map.Entry<YangSchemaNodeIdentifier, YobWorkBench> entry : this.attributeMap.entrySet()) {
            YobWorkBench childWorkBench = entry.getValue();
            YangSchemaNode childSchema = childWorkBench.schemaNode();
            childWorkBench.buildObject(reg);
            if (childSchema.getYangSchemaNodeType() == YangSchemaNodeType.YANG_AUGMENT_NODE) {
                YobWorkBench.addInAugmentation(this.builtObject, childWorkBench.getBuiltObject());
                continue;
            }
            YobWorkBench.setObjectInParent(this.builtObject, childWorkBench.setterInParent, childWorkBench.getBuiltObject(), DataNode.Type.SINGLE_INSTANCE_NODE);
        }
    }

    void buildObject(YangModelRegistry reg) {
        this.buildNonSchemaAttributes(reg);
    }
}

