/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.attributes.attributes;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.attributes.attributes.top.YangAutoPrefixInterface;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of top.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTop extends InnerModelObject implements Top {
    protected YangAutoPrefixInterface yangAutoPrefixInterface;

    @Override
    public YangAutoPrefixInterface yangAutoPrefixInterface() {
        return yangAutoPrefixInterface;
    }

    @Override
    public void yangAutoPrefixInterface(YangAutoPrefixInterface yangAutoPrefixInterface) {
        this.yangAutoPrefixInterface = yangAutoPrefixInterface;
    }

    @Override
    public int hashCode() {
        return Objects.hash(yangAutoPrefixInterface);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTop) {
            DefaultTop other = (DefaultTop) obj;
            return
                Objects.deepEquals(yangAutoPrefixInterface, other.yangAutoPrefixInterface);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("yangAutoPrefixInterface=" + yangAutoPrefixInterface)
            .toString();
    }


    /**
     * Creates an instance of defaultTop.
     */
    public DefaultTop() {
    }

}