/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.augmentchoice.rev20160826.augmentchoice.contenttest.valid;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.augmentchoice.rev20160826.augmentchoice.Ip;
import org.onosproject.yang.gen.v1.augmentchoice.rev20160826.augmentchoice.contenttest.valid.augmentedschvalid.AugCaseModKey;
import org.onosproject.yang.gen.v1.augmentchoice.rev20160826.augmentchoice.contenttest.valid.augmentedschvalid.TestedCont;
import org.onosproject.yang.gen.v1.augmentchoice.rev20160826.augmentchoice.contenttest.valid.augmentedschvalid.UnlistedVal;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of augmentedSchValid.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAugmentedSchValid extends InnerModelObject implements AugmentedSchValid {
    protected Class<? extends Ip> chTest;
    protected List<Byte> test;
    protected BitSet valueLeafFlags = new BitSet();
    protected TestedCont testedCont;
    protected List<UnlistedVal> unlistedVal;
    protected List<AugCaseModKey> augCaseModKey;

    @Override
    public Class<? extends Ip> chTest() {
        return chTest;
    }

    @Override
    public List<Byte> test() {
        return test;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public TestedCont testedCont() {
        return testedCont;
    }

    @Override
    public List<UnlistedVal> unlistedVal() {
        return unlistedVal;
    }

    @Override
    public List<AugCaseModKey> augCaseModKey() {
        return augCaseModKey;
    }

    @Override
    public void chTest(Class<? extends Ip> chTest) {
        valueLeafFlags.set(LeafIdentifier.CHTEST.getLeafIndex());
        this.chTest = chTest;
    }

    @Override
    public void test(List<Byte> test) {
        valueLeafFlags.set(LeafIdentifier.TEST.getLeafIndex());
        this.test = test;
    }

    @Override
    public void testedCont(TestedCont testedCont) {
        this.testedCont = testedCont;
    }

    @Override
    public void unlistedVal(List<UnlistedVal> unlistedVal) {
        this.unlistedVal = unlistedVal;
    }

    @Override
    public void augCaseModKey(List<AugCaseModKey> augCaseModKey) {
        this.augCaseModKey = augCaseModKey;
    }

    @Override
    public void addToTest(Byte addTo) {
        if (test == null) {
            test = new ArrayList<>();
        }
        test.add(addTo);
    }


    @Override
    public void addToUnlistedVal(UnlistedVal addTo) {
        if (unlistedVal == null) {
            unlistedVal = new ArrayList<>();
        }
        unlistedVal.add(addTo);
    }


    @Override
    public void addToAugCaseModKey(AugCaseModKey addTo) {
        if (augCaseModKey == null) {
            augCaseModKey = new ArrayList<>();
        }
        augCaseModKey.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(chTest, test, valueLeafFlags, testedCont, unlistedVal, augCaseModKey);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAugmentedSchValid) {
            DefaultAugmentedSchValid other = (DefaultAugmentedSchValid) obj;
            return
                Objects.deepEquals(chTest, other.chTest) &&
                Objects.deepEquals(test, other.test) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(testedCont, other.testedCont) &&
                Objects.deepEquals(unlistedVal, other.unlistedVal) &&
                Objects.deepEquals(augCaseModKey, other.augCaseModKey);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("chTest=" + chTest)
            .add("test=" + test)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("testedCont=" + testedCont)
            .add("unlistedVal=" + unlistedVal)
            .add("augCaseModKey=" + augCaseModKey)
            .toString();
    }


    /**
     * Creates an instance of defaultAugmentedSchValid.
     */
    public DefaultAugmentedSchValid() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}