/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.check;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.check.check.Cont50;
import org.onosproject.yang.gen.v1.check.check.Cont53;
import org.onosproject.yang.gen.v1.check.check.List52;
import org.onosproject.yang.gen.v1.check.check.List56;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of check.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class CheckOpParam extends InnerModelObject implements Check {
    protected Cont50 cont50;
    protected List<List52> list52;
    protected Cont53 cont53;
    protected List<List56> list56;

    @Override
    public Cont50 cont50() {
        return cont50;
    }

    @Override
    public List<List52> list52() {
        return list52;
    }

    @Override
    public Cont53 cont53() {
        return cont53;
    }

    @Override
    public List<List56> list56() {
        return list56;
    }

    @Override
    public void cont50(Cont50 cont50) {
        this.cont50 = cont50;
    }

    @Override
    public void list52(List<List52> list52) {
        this.list52 = list52;
    }

    @Override
    public void cont53(Cont53 cont53) {
        this.cont53 = cont53;
    }

    @Override
    public void list56(List<List56> list56) {
        this.list56 = list56;
    }

    @Override
    public void addToList52(List52 addTo) {
        if (list52 == null) {
            list52 = new ArrayList<>();
        }
        list52.add(addTo);
    }


    @Override
    public void addToList56(List56 addTo) {
        if (list56 == null) {
            list56 = new ArrayList<>();
        }
        list56.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(cont50, list52, cont53, list56);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CheckOpParam) {
            CheckOpParam other = (CheckOpParam) obj;
            return
                Objects.deepEquals(cont50, other.cont50) &&
                Objects.deepEquals(list52, other.list52) &&
                Objects.deepEquals(cont53, other.cont53) &&
                Objects.deepEquals(list56, other.list56);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("cont50=" + cont50)
            .add("list52=" + list52)
            .add("cont53=" + cont53)
            .add("list56=" + list56)
            .toString();
    }

    /**
     * Creates an instance of checkOpParam.
     */
    public CheckOpParam() {
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}