/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.check.check;

import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of list52.
 */
public class List52Keys implements KeyInfo<DefaultList52> {
    protected int leaf52;
    /**
     * Returns the attribute leaf52.
     *
     * @return leaf52 value of leaf52
     */
    public int leaf52() {
        return leaf52;
    }

    /**
     * Sets the value to attribute leaf52.
     *
     * @param leaf52 value of leaf52
     */
    public void leaf52(int leaf52) {
        this.leaf52 = leaf52;
    }


    @Override
    public int hashCode() {
        return Objects.hash(leaf52);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof List52Keys) {
            List52Keys other = (List52Keys) obj;
            return
                Objects.deepEquals(leaf52, other.leaf52);
        }
        return false;
    }
}