/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.check.check.group1;

import java.lang.String;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of list57.
 */
public class List57Keys implements KeyInfo<DefaultList57> {
    protected String gl57;
    /**
     * Returns the attribute gl57.
     *
     * @return gl57 value of gl57
     */
    public String gl57() {
        return gl57;
    }

    /**
     * Sets the value to attribute gl57.
     *
     * @param gl57 value of gl57
     */
    public void gl57(String gl57) {
        this.gl57 = gl57;
    }


    @Override
    public int hashCode() {
        return Objects.hash(gl57);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof List57Keys) {
            List57Keys other = (List57Keys) obj;
            return
                Objects.deepEquals(gl57, other.gl57);
        }
        return false;
    }
}