/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.check.check.list56.cont56.augmentedcont56;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.check.check.group1.Cont58;
import org.onosproject.yang.gen.v1.check.check.group1.List57;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of cont57.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCont57 extends InnerModelObject implements Cont57 {
    protected int cl57;
    protected BitSet valueLeafFlags = new BitSet();
    protected Cont58 cont58;
    protected List<List57> list57;

    @Override
    public int cl57() {
        return cl57;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Cont58 cont58() {
        return cont58;
    }

    @Override
    public List<List57> list57() {
        return list57;
    }

    @Override
    public void cl57(int cl57) {
        valueLeafFlags.set(LeafIdentifier.CL57.getLeafIndex());
        this.cl57 = cl57;
    }

    @Override
    public void cont58(Cont58 cont58) {
        this.cont58 = cont58;
    }

    @Override
    public void list57(List<List57> list57) {
        this.list57 = list57;
    }

    @Override
    public void addToList57(List57 addTo) {
        if (list57 == null) {
            list57 = new ArrayList<>();
        }
        list57.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(cl57, valueLeafFlags, cont58, list57);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCont57) {
            DefaultCont57 other = (DefaultCont57) obj;
            return
                Objects.deepEquals(cl57, other.cl57) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.deepEquals(cont58, other.cont58) &&
                Objects.deepEquals(list57, other.list57);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("cl57=" + cl57)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("cont58=" + cont58)
            .add("list57=" + list57)
            .toString();
    }


    /**
     * Creates an instance of defaultCont57.
     */
    public DefaultCont57() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}