/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.enumlistkeytest.rev20160524.enumlistkeytest;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.enumlistkeytest.rev20160524.enumlistkeytest.enumlist.Enumleaf1Enum;
import org.onosproject.yang.gen.v1.enumlistkeytest.rev20160524.enumlistkeytest.enumlist.EnumleafEnum;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of enumList.
 */
public interface EnumList extends Augmentable  {

    /**
     * Identify the leaf of EnumList.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents enumleaf.
         */
        ENUMLEAF(1),
        /**
         * Represents enumleaf1.
         */
        ENUMLEAF1(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute enumleaf.
     *
     * @return enumleaf value of enumleaf
     */
    EnumleafEnum enumleaf();

    /**
     * Returns the attribute enumleaf1.
     *
     * @return enumleaf1 value of enumleaf1
     */
    Enumleaf1Enum enumleaf1();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute enumleaf.
     *
     * @param enumleaf value of enumleaf
     */
    void enumleaf(EnumleafEnum enumleaf);

    /**
     * Sets the attribute enumleaf1.
     *
     * @param enumleaf1 value of enumleaf1
     */
    void enumleaf1(Enumleaf1Enum enumleaf1);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}