/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.enumlistkeytest.rev20160524.enumlistkeytest.enumlist;

/**
 * Represents ENUM data of enumleaf1Enum.
 */
public enum Enumleaf1Enum {

    /**
     * Represents ten.
     */
    TEN(10, "ten"),

    /**
     * Represents hundred.
     */
    HUNDRED(100, "hundred"),

    /**
     * Represents thousand.
     */
    THOUSAND(1000, "thousand");

    private int enumleaf1Enum;
    private String schemaName;

    /**
     * Creates an instance of enumleaf1Enum.
     *
     * @param enumleaf1Enum value of enumleaf1Enum
     */
     Enumleaf1Enum(int enumleaf1Enum, String schemaName) {
        this.enumleaf1Enum = enumleaf1Enum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of enumleaf1Enum for.
     *
     * @param value value of enumleaf1Enum for
     * @return enumleaf1Enum for
     */
    public static Enumleaf1Enum of(int value) {
        switch (value) {
            case 10:
                return Enumleaf1Enum.TEN;
            case 100:
                return Enumleaf1Enum.HUNDRED;
            case 1000:
                return Enumleaf1Enum.THOUSAND;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of enumleaf1Enum for.
     *
     * @param value value of enumleaf1Enum for
     * @return enumleaf1Enum for
     */
    public static Enumleaf1Enum of(String value) {
        switch (value) {
            case "ten":
                return Enumleaf1Enum.TEN;
            case "hundred":
                return Enumleaf1Enum.HUNDRED;
            case "thousand":
                return Enumleaf1Enum.THOUSAND;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute enumleaf1Enum.
     *
     * @return enumleaf1Enum value of enumleaf1Enum
     */
    public int enumleaf1Enum() {
        return enumleaf1Enum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
