/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.hello.rev20150105.hello.hellosecond;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of helloSecondInput.
 */
public class DefaultHelloSecondInput extends InnerModelObject implements HelloSecondInput {
    protected byte[] x;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public byte[] x() {
        return x;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void x(byte[] x) {
        valueLeafFlags.set(LeafIdentifier.X.getLeafIndex());
        this.x = x;
    }

    @Override
    public int hashCode() {
        return Objects.hash(x, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultHelloSecondInput) {
            DefaultHelloSecondInput other = (DefaultHelloSecondInput) obj;
            return
                Objects.deepEquals(x, other.x) &&
                Objects.deepEquals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("x=" + x)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultHelloSecondInput.
     */
    public DefaultHelloSecondInput() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}