/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc;

/**
 * Represents the implementation of addressAllocationType.
 */
public abstract class AddressAllocationType {

    /**
     * Returns the attribute address-allocation-type.
     *
     * @return address-allocation-type value of address-allocation-type
     */
    public static String addressAllocationTypeToString() {
        return "address-allocation-type";
    }

    /**
     * Returns the object of addressAllocationType fromString input String addressAllocationType.
     *
     * @param valInString value of input String
     * @return addressAllocationType
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("address-allocation-type")) {
            return AddressAllocationType.class;
        } else if (valInString.equals("pe-dhcp")) {
            return PeDhcp.class;
        } else if (valInString.equals("static-address")) {
            return StaticAddress.class;
        } else if (valInString.equals("slaac")) {
            return Slaac.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}