/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc;

/**
 * Represents the implementation of hubSpokeDisjoint.
 */
public abstract class HubSpokeDisjoint extends VpnTopology {

    /**
     * Returns the attribute hub-spoke-disjoint.
     *
     * @return hub-spoke-disjoint value of hub-spoke-disjoint
     */
    public static String hubSpokeDisjointToString() {
        return "hub-spoke-disjoint";
    }

    /**
     * Returns the object of hubSpokeDisjoint fromString input String hubSpokeDisjoint.
     *
     * @param valInString value of input String
     * @return hubSpokeDisjoint
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("hub-spoke-disjoint")) {
            return HubSpokeDisjoint.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}