/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc;

/**
 * Represents the implementation of multicastRpDiscoveryType.
 */
public abstract class MulticastRpDiscoveryType {

    /**
     * Returns the attribute multicast-rp-discovery-type.
     *
     * @return multicast-rp-discovery-type value of multicast-rp-discovery-type
     */
    public static String multicastRpDiscoveryTypeToString() {
        return "multicast-rp-discovery-type";
    }

    /**
     * Returns the object of multicastRpDiscoveryType fromString input String multicastRpDiscoveryType.
     *
     * @param valInString value of input String
     * @return multicastRpDiscoveryType
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("multicast-rp-discovery-type")) {
            return MulticastRpDiscoveryType.class;
        } else if (valInString.equals("auto-rp")) {
            return AutoRp.class;
        } else if (valInString.equals("static-rp")) {
            return StaticRp.class;
        } else if (valInString.equals("bsr-rp")) {
            return BsrRp.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}