/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc;

/**
 * Represents the implementation of siteVpnFlavor.
 */
public abstract class SiteVpnFlavor {

    /**
     * Returns the attribute site-vpn-flavor.
     *
     * @return site-vpn-flavor value of site-vpn-flavor
     */
    public static String siteVpnFlavorToString() {
        return "site-vpn-flavor";
    }

    /**
     * Returns the object of siteVpnFlavor fromString input String siteVpnFlavor.
     *
     * @param valInString value of input String
     * @return siteVpnFlavor
     */
    public static Class fromString(String valInString) {
        if (valInString.equals("site-vpn-flavor")) {
            return SiteVpnFlavor.class;
        } else if (valInString.equals("site-vpn-flavor-single")) {
            return SiteVpnFlavorSingle.class;
        } else if (valInString.equals("site-vpn-flavor-multi")) {
            return SiteVpnFlavorMulti.class;
        } else if (valInString.equals("site-vpn-flavor-sub")) {
            return SiteVpnFlavorSub.class;
        } else if (valInString.equals("site-vpn-flavor-nni")) {
            return SiteVpnFlavorNni.class;
        }
        throw new IllegalArgumentException("not a valid input element");
    }
}