/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.accessdiversity.accessdiversity.constraints;

import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.PlacementDiversity;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of constraint.
 */
public class ConstraintKeys implements KeyInfo<DefaultConstraint> {
    protected Class<? extends PlacementDiversity> constraintType;
    /**
     * Returns the attribute constraintType.
     *
     * @return constraintType value of constraintType
     */
    public Class<? extends PlacementDiversity> constraintType() {
        return constraintType;
    }

    /**
     * Sets the value to attribute constraintType.
     *
     * @param constraintType value of constraintType
     */
    public void constraintType(Class<? extends PlacementDiversity> constraintType) {
        this.constraintType = constraintType;
    }


    @Override
    public int hashCode() {
        return Objects.hash(constraintType);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ConstraintKeys) {
            ConstraintKeys other = (ConstraintKeys) obj;
            return
                Objects.deepEquals(constraintType, other.constraintType);
        }
        return false;
    }
}