/*
 * Copyright 2017-present Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.accessdiversity.accessdiversity.constraints.constraint;

import org.onosproject.yang.gen.v1.ietfl3vpnsvc.rev20160730.ietfl3vpnsvc.accessdiversity.accessdiversity.constraints.constraint.target.TargetFlavor;
import org.onosproject.yang.model.Augmentable;

/**
 * Abstraction of an entity which represents the functionality of target.
 */
public interface Target extends Augmentable  {

    /**
     * Returns the attribute targetFlavor.
     *
     * @return targetFlavor value of targetFlavor
     */
    TargetFlavor targetFlavor();

    /**
     * Sets the attribute targetFlavor.
     *
     * @param targetFlavor value of targetFlavor
     */
    void targetFlavor(TargetFlavor targetFlavor);

}